/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.facete.treequery2.impl;

import java.util.Set;
import org.aksw.facete.v3.api.FacetConstraintControl;
import org.aksw.jenax.arq.util.expr.NodeValueUtils;
import org.aksw.jenax.arq.util.node.NodeCustom;
import org.aksw.jenax.arq.util.node.NodeUtils;
import org.aksw.jenax.facete.treequery2.impl.ConstraintControl2Impl;
import org.aksw.jenax.facete.treequery2.impl.FacetConstraints;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.expr.E_Bound;
import org.apache.jena.sparql.expr.E_Equals;
import org.apache.jena.sparql.expr.E_Regex;
import org.apache.jena.sparql.expr.E_Str;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprLib;
import org.apache.jena.sparql.expr.NodeValue;

public class ConstraintApi2Impl<T> {
    protected FacetConstraints<T> model;
    protected transient Expr exprVar;

    public ConstraintApi2Impl(FacetConstraints<T> model, T node) {
        this.model = model;
        this.exprVar = ExprLib.nodeToExpr((Node)NodeCustom.of(node));
    }

    public FacetConstraintControl createConstraint(Expr expr) {
        Set references = NodeCustom.mentionedValues(this.model.getConstraintClass(), (Expr)expr);
        ConstraintControl2Impl<T> result = new ConstraintControl2Impl<T>(this.model, references, expr);
        return result;
    }

    public FacetConstraintControl exists() {
        E_Bound expr = new E_Bound(this.exprVar);
        FacetConstraintControl result = this.createConstraint((Expr)expr);
        return result;
    }

    public FacetConstraintControl eq(Node node) {
        FacetConstraintControl result;
        if (node == null || NodeUtils.nullUriNode.equals((Object)node)) {
            result = this.absent();
        } else {
            E_Equals expr = new E_Equals(this.exprVar, (Expr)NodeValue.makeNode((Node)node));
            result = this.createConstraint((Expr)expr);
        }
        return result;
    }

    public FacetConstraintControl absent() {
        E_Equals expr = new E_Equals(this.exprVar, (Expr)NodeValueUtils.NV_ABSENT);
        FacetConstraintControl result = this.createConstraint((Expr)expr);
        return result;
    }

    public FacetConstraintControl regex(String pattern, String flags) {
        E_Regex expr = new E_Regex((Expr)new E_Str(this.exprVar), pattern, flags);
        FacetConstraintControl result = this.createConstraint((Expr)expr);
        return result;
    }
}

