/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.data_query.impl;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import com.google.common.graph.Traverser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.aksw.jena_sparql_api.data_query.api.PathAccessor;
import org.aksw.jena_sparql_api.data_query.impl.PathAccessorUtils;
import org.aksw.jena_sparql_api.data_query.impl.PathToRelationMapper;
import org.aksw.jena_sparql_api.data_query.impl.QueryFragment;
import org.aksw.jenax.arq.util.expr.ExprUtils;
import org.aksw.jenax.arq.util.expr.NodeValueUtils;
import org.aksw.jenax.arq.util.node.NodeTransformRenameMap;
import org.aksw.jenax.arq.util.syntax.ElementUtils;
import org.aksw.jenax.arq.util.var.VarUtils;
import org.aksw.jenax.arq.util.var.Vars;
import org.aksw.jenax.sparql.fragment.api.Fragment;
import org.aksw.jenax.sparql.fragment.api.Fragment1;
import org.aksw.jenax.sparql.fragment.api.Fragment2;
import org.aksw.jenax.sparql.fragment.api.Fragment3;
import org.aksw.jenax.sparql.fragment.api.HasElement;
import org.aksw.jenax.sparql.fragment.impl.Concept;
import org.aksw.jenax.sparql.fragment.impl.ConceptUtils;
import org.aksw.jenax.sparql.fragment.impl.ExprFragment;
import org.aksw.jenax.sparql.fragment.impl.Fragment2Impl;
import org.aksw.jenax.sparql.fragment.impl.Fragment3Impl;
import org.aksw.jenax.sparql.fragment.impl.FragmentUtils;
import org.aksw.jenax.sparql.path.PathUtils;
import org.aksw.jenax.sparql.path.SimplePath;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.expr.E_Bound;
import org.apache.jena.sparql.expr.E_Equals;
import org.apache.jena.sparql.expr.E_LogicalNot;
import org.apache.jena.sparql.expr.E_NotOneOf;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprTransform;
import org.apache.jena.sparql.expr.ExprTransformer;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.aggregate.AggCountVarDistinct;
import org.apache.jena.sparql.expr.aggregate.Aggregator;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.graph.NodeTransformExpr;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementBind;
import org.apache.jena.sparql.syntax.ElementFilter;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.ElementOptional;
import org.apache.jena.sparql.syntax.ElementSubQuery;
import org.apache.jena.sparql.syntax.ElementTriplesBlock;
import org.apache.jena.sparql.syntax.PatternVars;
import org.apache.jena.vocabulary.RDF;

public class FacetedQueryGenerator<P> {
    protected Fragment1 baseConcept;
    protected PathToRelationMapper<P> mapper;
    protected Collection<Expr> constraints;
    protected PathAccessor<P> pathAccessor;

    public static <P> NodeTransform createNodeTransformSubstitutePathReferences(PathToRelationMapper<P> mapper, PathAccessor<P> pathAccessor) {
        NodeTransform result = PathToRelationMapper.createNodeTransformSubstitutePathReferences(arg_0 -> pathAccessor.tryMapToPath(arg_0), mapper::getNode);
        return result;
    }

    public FacetedQueryGenerator(PathAccessor<P> pathAccessor) {
        this.pathAccessor = pathAccessor;
        this.mapper = new PathToRelationMapper<P>(pathAccessor);
        this.constraints = new LinkedHashSet<Expr>();
    }

    public void addConstraint(Expr expr) {
        this.constraints.add(expr);
    }

    public void setBaseConcept(Fragment1 baseConcept) {
        this.baseConcept = baseConcept;
    }

    public SetMultimap<P, Expr> hideConstraintsForPath(SetMultimap<P, Expr> constaintIndex, P path) {
        SetMultimap result = Multimaps.filterKeys(constaintIndex, k -> !Objects.equals(k, path));
        return result;
    }

    public static <T> SimplePath toSimplePath(T path, PathAccessor<T> pathAccessor) {
        List steps = Streams.stream((Iterable)Traverser.forTree(x -> Optional.ofNullable(pathAccessor.getParent(x)).map(Collections::singleton).orElse(Collections.emptySet())).depthFirstPostOrder(path)).filter(x -> pathAccessor.getParent(x) != null).map(x -> PathUtils.createStep((String)pathAccessor.getPredicate(x), (!pathAccessor.isReverse(x) ? 1 : 0) != 0)).collect(Collectors.toList());
        SimplePath result = new SimplePath(steps);
        return result;
    }

    public static <P> Fragment2 createRelationForPath(PathToRelationMapper<P> mapper, PathAccessor<P> pathAccessor, P childPath, boolean includeAbsent) {
        Fragment2 result;
        if (includeAbsent) {
            Object parent = pathAccessor.getParent(childPath);
            Fragment2 tmp = mapper.getOverallRelation(childPath);
            Fragment2 br = mapper.getOverallRelation(parent);
            Fragment2 rawLastStep = pathAccessor.getReachingRelation(childPath);
            Fragment2Impl helper = new Fragment2Impl((Element)new ElementGroup(), br.getTargetVar(), tmp.getTargetVar());
            Fragment2 lastStep = helper.joinOn(new Var[]{helper.getSourceVar(), helper.getTargetVar()}).with((Fragment)rawLastStep, new Var[0]).toFragment2();
            ArrayList<ElementOptional> elts = new ArrayList<ElementOptional>();
            elts.addAll(br.getElements());
            elts.add(new ElementOptional(lastStep.getElement()));
            Element group = ElementUtils.groupIfNeeded(elts);
            result = new Fragment2Impl(group, tmp.getSourceVar(), lastStep.getTargetVar());
        } else {
            result = mapper.getOverallRelation(childPath);
        }
        return result;
    }

    public Fragment2 createRelationForPath(P childPath, SetMultimap<P, Expr> constraintIndex, boolean applySelfConstraints, boolean negated, boolean includeAbsent) {
        Fragment2 result;
        Fragment2 facetRelation = FacetedQueryGenerator.createRelationForPath(this.mapper, this.pathAccessor, childPath, includeAbsent);
        if (!facetRelation.isEmpty()) {
            SetMultimap<P, Expr> effectiveCi;
            ArrayList<ElementBind> elts = new ArrayList<ElementBind>();
            SetMultimap<P, Expr> setMultimap = effectiveCi = applySelfConstraints ? constraintIndex : this.hideConstraintsForPath(constraintIndex, childPath);
            if (!effectiveCi.containsKey(childPath)) {
                elts.addAll(facetRelation.getElements());
            }
            elts.add(new ElementBind(Vars.p, (Expr)NodeValue.makeNode((Node)NodeFactory.createURI((String)this.pathAccessor.getPredicate(childPath)))));
            facetRelation = new Fragment2Impl(ElementUtils.groupIfNeeded(elts), facetRelation.getSourceVar(), facetRelation.getTargetVar());
            Object rootPath = FacetedQueryGenerator.getRoot(childPath, arg_0 -> this.pathAccessor.getParent(arg_0));
            result = this.createConstraintRelationForPath((P)rootPath, childPath, facetRelation, Vars.p, (Multimap<P, Expr>)effectiveCi, negated, includeAbsent);
        } else {
            result = facetRelation;
        }
        return result;
    }

    public Fragment2 getRemainingFacets(P focusPath, P facetOriginPath, boolean isReverse, SetMultimap<P, Expr> constraintIndex, boolean negated, boolean includeAbsent) {
        Fragment2 result = includeAbsent ? this.getRemainingFacetsWithAbsent(focusPath, facetOriginPath, isReverse, constraintIndex, negated) : this.getRemainingFacetsWithoutAbsent(facetOriginPath, isReverse, constraintIndex, negated, includeAbsent);
        return result;
    }

    public Fragment2 getRemainingFacetsWithAbsent(P focusPath, P facetOriginPath, boolean isReverse, SetMultimap<P, Expr> constraintIndex, boolean negated) {
        boolean includeAbsent = true;
        ElementTriplesBlock tripleEl = ElementUtils.createElement((Triple)QueryFragment.createTriple(isReverse, (Node)Vars.s, (Node)Vars.p, (Node)Vars.o));
        ElementOptional baseEl = new ElementOptional((Element)tripleEl);
        Fragment2Impl br = new Fragment2Impl((Element)baseEl, Vars.s, Vars.o);
        Fragment2 rel = this.mapper.getOverallRelation(facetOriginPath);
        Fragment2 tmp = this.createConstraintRelationForPath(facetOriginPath, null, (Fragment2)br, Vars.p, (Multimap<P, Expr>)constraintIndex, false, includeAbsent);
        ArrayList elts = new ArrayList();
        Map<String, Fragment3> rawRelations3 = this.getFacetValuesCore(this.baseConcept, focusPath, facetOriginPath, null, null, isReverse, negated, false, false);
        Fragment3 tr = rawRelations3.get(null);
        Fragment1 rawFacetConcept = tr.project(new Var[]{tr.getP()}).toFragment1();
        Fragment1 facetConcept = rawFacetConcept.rename(varName -> "opt_" + varName, new Var[]{Vars.p}).toFragment1();
        elts.addAll(facetConcept.getElements());
        elts.addAll(rel.getElements());
        elts.addAll(tmp.getElements());
        Fragment2Impl result = new Fragment2Impl(ElementUtils.groupIfNeeded(elts), tmp.getSourceVar(), tmp.getTargetVar());
        return result;
    }

    public Fragment2 getRemainingFacetsWithoutAbsent(P facetOriginPath, boolean isReverse, SetMultimap<P, Expr> constraintIndex, boolean negated, boolean includeAbsent) {
        ElementTriplesBlock baseEl = ElementUtils.createElement((Triple)QueryFragment.createTriple(isReverse, (Node)Vars.s, (Node)Vars.p, (Node)Vars.o));
        Fragment2Impl br = new Fragment2Impl((Element)baseEl, Vars.s, Vars.o);
        Fragment2 rel = this.mapper.getOverallRelation(facetOriginPath);
        Fragment2 tmp = this.createConstraintRelationForPath(facetOriginPath, null, (Fragment2)br, Vars.p, (Multimap<P, Expr>)constraintIndex, false, includeAbsent);
        ArrayList elts = new ArrayList();
        elts.addAll(rel.getElements());
        elts.addAll(tmp.getElements());
        Fragment2Impl result = new Fragment2Impl(ElementUtils.groupIfNeeded(elts), tmp.getSourceVar(), tmp.getTargetVar());
        return result;
    }

    public static boolean containsAbsent(Collection<? extends Expr> exprs) {
        boolean result = exprs.stream().anyMatch(FacetedQueryGenerator::isAbsent);
        return result;
    }

    public static int compareAbsent(Expr a, Expr b) {
        int result = ComparisonChain.start().compareFalseFirst(FacetedQueryGenerator.isAbsent(a), FacetedQueryGenerator.isAbsent(b)).result();
        return result;
    }

    public static int compareAbsent(Collection<? extends Expr> a, Collection<? extends Expr> b) {
        int result = ComparisonChain.start().compareFalseFirst(FacetedQueryGenerator.containsAbsent(a), FacetedQueryGenerator.containsAbsent(b)).result();
        return result;
    }

    public static boolean isAbsent(Expr expr) {
        E_Equals e;
        boolean result = expr instanceof E_Equals ? (e = (E_Equals)expr).getArg2() == null || e.getArg2().equals((Object)NodeValueUtils.NV_ABSENT) : false;
        return result;
    }

    public static Expr internalRewriteAbsent(Expr expr) {
        return new E_LogicalNot((Expr)new E_Bound((Expr)expr.getFunction().getArgs().get(0)));
    }

    public static <P> Map<P, Fragment2> allocatePathRelations(PathToRelationMapper<P> mapper, PathAccessor<P> pathAccessor, Multimap<P, Expr> constraintIndex) {
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry e : constraintIndex.asMap().entrySet()) {
            Object path = e.getKey();
            Collection exprs = (Collection)e.getValue();
            boolean containsAbsent = FacetedQueryGenerator.containsAbsent(exprs);
            Fragment2 br = FacetedQueryGenerator.createRelationForPath(mapper, pathAccessor, path, containsAbsent);
            result.put(path, br);
        }
        return result;
    }

    public static <P> Collection<Element> createElementsForExprs(PathToRelationMapper<P> mapper, PathAccessor<P> pathAccessor, Collection<Expr> constraints, boolean negate) {
        SetMultimap<P, Expr> constraintIndex = FacetedQueryGenerator.indexConstraints(pathAccessor, constraints);
        Map<P, Fragment2> pathToRelation = FacetedQueryGenerator.allocatePathRelations(mapper, pathAccessor, constraintIndex);
        Collection<Element> result = FacetedQueryGenerator.createElementsForExprs(mapper, pathAccessor, pathToRelation, constraints, negate);
        return result;
    }

    public static <P> Collection<Element> createElementsForExprs(PathToRelationMapper<P> mapper, PathAccessor<P> pathAccessor, Map<P, Fragment2> pathToRelation, Collection<Expr> baseExprs, boolean negate) {
        NodeTransform nodeTransform = FacetedQueryGenerator.createNodeTransformSubstitutePathReferences(mapper, pathAccessor);
        LinkedHashSet<Element> result = new LinkedHashSet<Element>();
        LinkedHashSet<Expr> resolvedExprs = new LinkedHashSet<Expr>();
        List tmp = baseExprs.stream().map(e -> FacetedQueryGenerator.isAbsent(e) ? FacetedQueryGenerator.internalRewriteAbsent(e) : e).collect(Collectors.toList());
        ArrayList exprs = new ArrayList(tmp);
        Collections.sort(exprs, FacetedQueryGenerator::compareAbsent);
        for (Expr expr : exprs) {
            Collection<Object> paths = PathAccessorUtils.getPathsMentioned(expr, arg_0 -> pathAccessor.tryMapToPath(arg_0)).values();
            for (Object path : paths) {
                Fragment2 br = pathToRelation.get(path);
                result.addAll(br.getElements());
            }
        }
        for (Expr expr : exprs) {
            Expr resolved = ExprTransformer.transform((ExprTransform)new NodeTransformExpr(nodeTransform), (Expr)expr);
            resolvedExprs.add(resolved);
        }
        Expr resolvedPathExpr = ExprUtils.orifyBalanced(resolvedExprs);
        if (resolvedPathExpr != null) {
            if (negate) {
                resolvedPathExpr = new E_LogicalNot(resolvedPathExpr);
            }
            if (!NodeValue.TRUE.equals((Object)resolvedPathExpr)) {
                result.add((Element)new ElementFilter(resolvedPathExpr));
            }
        }
        return result;
    }

    public Fragment2 createConstraintRelationForPath(P rootPath, P childPath, Fragment2 facetRelation, Var pVar, Multimap<P, Expr> constraintIndex, boolean negate, boolean includeAbsent) {
        Set<Element> elts = this.createElementsFromConstraintIndex(constraintIndex, p -> !negate ? false : (childPath == null ? true : Objects.equals(p, childPath)));
        Var s = (Var)this.mapper.getNode(rootPath);
        HashSet forbiddenVars = new HashSet();
        for (Element e : elts) {
            Collection v = PatternVars.vars((Element)e);
            forbiddenVars.addAll(v);
        }
        Set vars = facetRelation.getVarsMentioned();
        Map rename = VarUtils.createDistinctVarMap(forbiddenVars, Arrays.asList(pVar, facetRelation.getTargetVar()), (boolean)true, null);
        rename.put(facetRelation.getSourceVar(), s);
        Fragment2 renamedFacetRelation = facetRelation.applyNodeTransform((NodeTransform)NodeTransformRenameMap.create((Map)rename));
        elts.addAll(renamedFacetRelation.getElements());
        Fragment2Impl result = new Fragment2Impl(ElementUtils.groupIfNeeded(elts), pVar, rename.getOrDefault(facetRelation.getTargetVar(), facetRelation.getTargetVar()));
        return result;
    }

    public static Fragment1 createConceptFacets(Map<String, Fragment3> relations, Concept pConstraint) {
        List elements = relations.values().stream().map(e -> e.project(new Var[]{e.getP()})).map(e -> FragmentUtils.rename((Fragment)e, Arrays.asList(Vars.p))).map(Fragment::toFragment1).map(HasElement::getElement).collect(Collectors.toList());
        Element e2 = ElementUtils.unionIfNeeded(elements);
        Concept result = new Concept(e2, Vars.p);
        return result;
    }

    @Deprecated
    public static Fragment1 createConceptFacetsOld(Map<String, Fragment2> relations, Concept pConstraint) {
        List elements = relations.values().stream().map(e -> FragmentUtils.rename((Fragment)e, Arrays.asList(Vars.p, Vars.o))).map(Fragment::toFragment2).map(HasElement::getElement).collect(Collectors.toList());
        Element e2 = ElementUtils.unionIfNeeded(elements);
        Concept result = new Concept(e2, Vars.p);
        return result;
    }

    public static Fragment2 createRelationFacetsAndCounts(Map<String, Fragment3> relationsFocusFacetValue, Concept pConstraint, boolean includeAbsent, boolean focusCount) {
        Var countVar = Var.alloc((String)"__count__");
        List elements = relationsFocusFacetValue.values().stream().map(e -> e.project(new Var[]{e.getP(), focusCount ? e.getS() : e.getO()})).map(e -> FragmentUtils.rename((Fragment)e, Arrays.asList(Vars.p, Vars.o))).map(Fragment::toFragment2).map(e -> pConstraint == null ? e : e.joinOn(new Var[]{e.getSourceVar()}).with((Fragment1)pConstraint)).map(e -> FragmentUtils.groupBy((Fragment)e, (Var)Vars.o, (Var)countVar, (boolean)includeAbsent)).map(HasElement::getElement).collect(Collectors.toList());
        Element e2 = ElementUtils.unionIfNeeded(elements);
        Fragment2Impl result = new Fragment2Impl(e2, Vars.p, countVar);
        return result;
    }

    @Deprecated
    public static Fragment2 createRelationFacetsAndCountsOld(Map<String, Fragment2> relations, Concept pConstraint, boolean includeAbsent) {
        Var countVar = Var.alloc((String)"__count__");
        List elements = relations.values().stream().map(e -> FragmentUtils.rename((Fragment)e, Arrays.asList(Vars.p, Vars.o))).map(Fragment::toFragment2).map(e -> e.joinOn(new Var[]{e.getSourceVar()}).with((Fragment1)pConstraint)).map(e -> FragmentUtils.groupBy((Fragment)e, (Var)Vars.o, (Var)countVar, (boolean)includeAbsent)).map(HasElement::getElement).collect(Collectors.toList());
        Element e2 = ElementUtils.unionIfNeeded(elements);
        Fragment2Impl result = new Fragment2Impl(e2, Vars.p, countVar);
        return result;
    }

    @Deprecated
    public boolean isExprExcluded(Expr expr, P path, boolean isReverse) {
        boolean result = false;
        Collection<Object> paths = PathAccessorUtils.getPathsMentioned(expr, arg_0 -> this.pathAccessor.tryMapToPath(arg_0)).values();
        for (Object candPath : paths) {
            Object parentPath = this.pathAccessor.getParent(candPath);
            boolean candIsReverse = this.pathAccessor.isReverse(candPath);
            if (!path.equals(parentPath) || isReverse != candIsReverse) continue;
            result = true;
        }
        return result;
    }

    public Map<String, Fragment2> createMapFacetsAndValues(P focusPath, P facetOriginPath, boolean isReverse, boolean applySelfConstraints, boolean negated, boolean includeAbsent) {
        SetMultimap<P, Expr> constraintIndex = FacetedQueryGenerator.indexConstraints(this.pathAccessor, this.constraints);
        HashMap<String, Fragment2> result = new HashMap<String, Fragment2>();
        Set mentionedPaths = constraintIndex.keySet();
        Set<P> constrainedChildPaths = this.extractChildPaths(facetOriginPath, isReverse, mentionedPaths);
        for (P childPath : constrainedChildPaths) {
            Fragment2 br = this.createRelationForPath(childPath, constraintIndex, applySelfConstraints, negated, includeAbsent);
            String pStr2 = this.pathAccessor.getPredicate(childPath);
            String string = pStr2 = pStr2 == null ? "" : pStr2;
            if (pStr2.isEmpty() && br.isEmpty()) continue;
            result.put(pStr2, br);
        }
        Fragment2 brr = this.getRemainingFacets(focusPath, facetOriginPath, isReverse, constraintIndex, negated, includeAbsent);
        ExprList constrainedPredicates = new ExprList(result.keySet().stream().filter(pStr -> !pStr.isEmpty()).map(NodeFactory::createURI).map(NodeValue::makeNode).collect(Collectors.toList()));
        if (!constrainedPredicates.isEmpty()) {
            List foo = brr.getElements();
            foo.add(new ElementFilter((Expr)new E_NotOneOf((Expr)new ExprVar(brr.getSourceVar()), constrainedPredicates)));
            brr = new Fragment2Impl(ElementUtils.groupIfNeeded((Iterable)foo), brr.getSourceVar(), brr.getTargetVar());
        }
        result.put(null, brr);
        return result;
    }

    public Fragment3 createRelationFacetValue(P focus, P facetPath, boolean isReverse, Fragment1 pFilter, Fragment1 oFilter, boolean applySelfConstraints, boolean includeAbsent) {
        Map<String, Fragment3> facetValues = this.getFacetValuesCore(this.baseConcept, focus, facetPath, pFilter, oFilter, isReverse, false, applySelfConstraints, includeAbsent);
        List elements = facetValues.values().stream().map(e -> FragmentUtils.rename((Fragment)e, Arrays.asList(Vars.s, Vars.p, Vars.o))).map(Fragment::toFragment3).map(e -> e.joinOn(new Var[]{e.getP()}).with(pFilter)).map(HasElement::getElement).collect(Collectors.toList());
        Element e2 = ElementUtils.unionIfNeeded(elements);
        Fragment3Impl result = new Fragment3Impl(e2, Vars.s, Vars.p, Vars.o);
        return result;
    }

    public Fragment3 createRelationFacetValueTypeCounts(P focus, P facetPath, boolean isReverse, boolean negated, Fragment1 pFilter, Fragment1 oFilter, boolean includeAbsent) {
        Map<String, Fragment3> facetValues = this.getFacetValuesCore(this.baseConcept, focus, facetPath, pFilter, oFilter, isReverse, negated, false, includeAbsent);
        Fragment2 typeRel = Fragment2Impl.createFwd((Var)Vars.s, (Node)RDF.type.asNode(), (Var)Vars.o);
        Var countVar = Vars.c;
        List elements = facetValues.values().stream().map(e -> FragmentUtils.rename((Fragment)e, Arrays.asList(Vars.s, Vars.p, Vars.o))).map(r -> r.joinOn(new Var[]{Vars.o}).projectSrcVars(new Var[]{Vars.s, Vars.p}).projectTgtVars(new Var[]{Vars.o}).with((Fragment)typeRel, new Var[]{Vars.s})).map(Fragment::toFragment3).map(e -> e.joinOn(new Var[]{e.getP()}).with(pFilter)).map(e -> FragmentUtils.groupBy((Fragment)e, (Var)Vars.s, (Var)countVar, (boolean)includeAbsent)).map(HasElement::getElement).collect(Collectors.toList());
        Element e2 = ElementUtils.unionIfNeeded(elements);
        Fragment3Impl result = new Fragment3Impl(e2, Vars.p, Vars.o, countVar);
        return result;
    }

    public Fragment3 createRelationFacetValueCounts(P focus, P facetPath, boolean isReverse, boolean negated, Fragment1 pFilter, Fragment1 oFilter, boolean includeAbsent) {
        Map<String, Fragment3> facetValues = this.getFacetValuesCore(this.baseConcept, focus, facetPath, pFilter, oFilter, isReverse, negated, false, includeAbsent);
        Var countVar = Vars.c;
        List elements = facetValues.values().stream().map(e -> FragmentUtils.rename((Fragment)e, Arrays.asList(Vars.s, Vars.p, Vars.o))).map(Fragment::toFragment3).map(e -> pFilter == null ? e : e.joinOn(new Var[]{e.getP()}).with(pFilter)).map(e -> FragmentUtils.groupBy((Fragment)e, (Var)Vars.s, (Var)countVar, (boolean)includeAbsent)).map(HasElement::getElement).collect(Collectors.toList());
        Element e2 = ElementUtils.unionIfNeeded(elements);
        Fragment3Impl result = new Fragment3Impl(e2, Vars.p, Vars.o, countVar);
        return result;
    }

    public static <T> T getRoot(T item, Function<? super T, ? extends T> getParent) {
        Object result = null;
        while (item != null) {
            result = item;
            item = getParent.apply(result);
        }
        return result;
    }

    public ExprFragment getConstraintExpr(P facetPath, boolean isReverse) {
        return null;
    }

    public Set<P> extractChildPaths(P basePath, boolean isReverse, Collection<P> candidates) {
        LinkedHashSet<P> result = new LinkedHashSet<P>();
        for (P cand : candidates) {
            boolean isCandBwd;
            Object candParent = this.pathAccessor.getParent(cand);
            if (candParent == null || isReverse != (isCandBwd = this.pathAccessor.isReverse(cand)) || !Objects.equals(basePath, candParent)) continue;
            result.add(cand);
        }
        return result;
    }

    public static <P> SetMultimap<P, Expr> indexConstraints(PathAccessor<P> pathAccessor, Collection<Expr> constraints) {
        LinkedHashMultimap result = LinkedHashMultimap.create();
        for (Expr expr : constraints) {
            Collection<Object> paths = PathAccessorUtils.getPathsMentioned(expr, arg_0 -> pathAccessor.tryMapToPath(arg_0)).values();
            for (Object path : paths) {
                result.put(path, (Object)expr);
            }
        }
        return result;
    }

    public Set<Element> createElementsFromConstraintIndex(Multimap<P, Expr> constraintIndex, Predicate<? super P> negatePath) {
        LinkedHashSet<Element> result = new LinkedHashSet<Element>();
        Map map = constraintIndex.asMap();
        ArrayList order = new ArrayList(constraintIndex.keySet());
        Collections.sort(order, (a, b) -> FacetedQueryGenerator.compareAbsent((Collection)map.get(a), (Collection)map.get(b)));
        Map<P, Fragment2> pathToRelation = FacetedQueryGenerator.allocatePathRelations(this.mapper, this.pathAccessor, constraintIndex);
        for (Object path : order) {
            Collection exprs = (Collection)map.get(path);
            boolean negated = negatePath == null ? false : negatePath.test(path);
            Collection<Element> eltContribs = FacetedQueryGenerator.createElementsForExprs(this.mapper, this.pathAccessor, pathToRelation, exprs, negated);
            result.addAll(eltContribs);
        }
        return result;
    }

    public Fragment1 getConceptForAtPath(P focusPath, P facetPath, boolean applySelfConstraints) {
        SetMultimap<P, Expr> rawIndex = FacetedQueryGenerator.indexConstraints(this.pathAccessor, this.constraints);
        SetMultimap<P, Expr> childPathToExprs = applySelfConstraints ? rawIndex : this.hideConstraintsForPath(rawIndex, facetPath);
        Set<Element> elts = this.createElementsFromConstraintIndex((Multimap<P, Expr>)childPathToExprs, null);
        Fragment2 focusRelation = this.mapper.getOverallRelation(focusPath);
        elts.addAll(focusRelation.getElements());
        Fragment2 facetRelation = this.mapper.getOverallRelation(facetPath);
        elts.addAll(facetRelation.getElements());
        Var resultVar = (Var)this.mapper.getNode(facetPath);
        Object rootPath = FacetedQueryGenerator.getRoot(facetPath, arg_0 -> this.pathAccessor.getParent(arg_0));
        Var rootVar = (Var)this.mapper.getNode(rootPath);
        Concept result = new Concept(ElementUtils.groupIfNeeded(elts), resultVar);
        result = result.prependOn(new Var[]{rootVar}).with(this.baseConcept).toFragment1();
        return result;
    }

    public Map<String, Fragment3> getFacetValuesCore(Fragment1 baseConcept, P focusPath, P facetPath, Fragment1 pFilter, Fragment1 oFilter, boolean isReverse, boolean negated, boolean applySelfConstraints, boolean includeAbsent) {
        Fragment2 focusRelation = this.mapper.getOverallRelation(focusPath);
        Map<String, Fragment2> facets = this.createMapFacetsAndValues(focusPath, facetPath, isReverse, applySelfConstraints, negated, includeAbsent);
        LinkedHashSet e1 = new LinkedHashSet(ElementUtils.toElementList((Element)focusRelation.getElement()));
        HashMap<String, Fragment3> result = new HashMap<String, Fragment3>();
        for (Map.Entry<String, Fragment2> facet : facets.entrySet()) {
            Fragment2 rel = facet.getValue();
            LinkedHashSet e2 = new LinkedHashSet(ElementUtils.toElementList((Element)rel.getElement()));
            Sets.SetView e3 = Sets.union(e1, e2);
            Element e4 = ElementUtils.groupIfNeeded((Iterable)e3);
            Fragment1 bc = Optional.ofNullable(baseConcept).orElse(ConceptUtils.createSubjectConcept());
            Object rootPath = FacetedQueryGenerator.getRoot(facetPath, arg_0 -> this.pathAccessor.getParent(arg_0));
            Var rootVar = (Var)this.mapper.getNode(rootPath);
            Concept c4 = new Concept(e4, rootVar);
            Fragment tmp = c4.prependOn(new Var[]{rootVar}).with(bc);
            Element e5 = tmp.getElement();
            Fragment3Impl tr = new Fragment3Impl(e5, focusRelation.getTargetVar(), rel.getSourceVar(), rel.getTargetVar());
            String p = facet.getKey();
            result.put(p, (Fragment3)tr);
        }
        return result;
    }

    public static Concept createConceptFacets(Fragment3 tr) {
        Concept result = new Concept(tr.getElement(), tr.getP());
        return result;
    }

    public static Fragment3 countFacetValues(Fragment3 tr, int sortDirection) {
        Query query = new Query();
        query.setQuerySelectType();
        query.setQueryPattern(tr.getElement());
        Expr agg = query.allocAggregate((Aggregator)new AggCountVarDistinct((Expr)new ExprVar(tr.getS())));
        VarExprList vel = query.getProject();
        Var p = tr.getP();
        Var o = tr.getO();
        Var c = Vars.c;
        vel.add(p);
        vel.add(o);
        vel.add(c, agg);
        query.addGroupBy((Node)p);
        query.addGroupBy((Node)o);
        Fragment3Impl result = new Fragment3Impl((Element)new ElementSubQuery(query), p, o, c);
        if (sortDirection != 0) {
            query.addOrderBy(agg, sortDirection);
        }
        return result;
    }
}

