/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.facete.v4.impl;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.aksw.commons.path.core.PathBase;
import org.aksw.facete.v3.api.TreeData;
import org.aksw.facete.v3.api.TreeDataMap;
import org.aksw.facete.v3.api.VarScope;
import org.aksw.facete.v4.impl.ElementAcc;
import org.aksw.jenax.path.core.FacetPath;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.Expr;

public class ElementGeneratorContext {
    protected VarScope scope;
    protected TreeData<FacetPath> facetTree;
    protected SetMultimap<FacetPath, Expr> localConstraintIndex;
    protected Set<FacetPath> mandatoryElementIds = new HashSet<FacetPath>();
    protected TreeDataMap<FacetPath, ElementAcc> facetPathToAcc = new TreeDataMap();
    protected Map<FacetPath, Var> pathToVar = new LinkedHashMap<FacetPath, Var>();

    public ElementGeneratorContext(Var rootVar, TreeData<FacetPath> facetTree, SetMultimap<FacetPath, Expr> localConstraintIndex) {
        this(VarScope.of((String)"", (Var)rootVar), facetTree, localConstraintIndex);
    }

    public ElementGeneratorContext(VarScope scope) {
        this(scope, (TreeData<FacetPath>)new TreeData(), (SetMultimap<FacetPath, Expr>)HashMultimap.create());
    }

    public ElementGeneratorContext(VarScope scope, TreeData<FacetPath> facetTree, SetMultimap<FacetPath, Expr> localConstraintIndex) {
        this.scope = scope;
        this.facetTree = facetTree;
        this.localConstraintIndex = localConstraintIndex;
    }

    public ElementGeneratorContext setFacetTree(TreeData<FacetPath> facetTree) {
        this.facetTree = facetTree;
        return this;
    }

    public ElementGeneratorContext setConstraintIndex(SetMultimap<FacetPath, Expr> localConstraintIndex) {
        this.localConstraintIndex = localConstraintIndex;
        localConstraintIndex.keySet().forEach(this::addPath);
        return this;
    }

    public VarScope getScope() {
        return this.scope;
    }

    public void addPath(FacetPath facetPath) {
        this.facetTree.putItem((Object)facetPath, PathBase::getParent);
    }

    public Map<FacetPath, Var> getPathToVar() {
        return this.pathToVar;
    }
}

