/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.facete.v3.impl;

import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import org.aksw.jena_sparql_api.rdf.collections.NodeMappers;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;

public interface RangeSpec
extends Resource {
    public RDFNode getMin();

    public void setMin(RDFNode var1);

    public boolean isMinInclusive();

    public void setMinInclusive(boolean var1);

    public RDFNode getMax();

    public void setMax(RDFNode var1);

    public boolean isMaxInclusive();

    public void setMaxInclusive(boolean var1);

    default public <T> T getMin(Class<T> clazz) {
        return (T)NodeMappers.from(clazz).toJava((Object)this.getMin().asNode());
    }

    default public <T> T getMax(Class<T> clazz) {
        return (T)NodeMappers.from(clazz).toJava((Object)this.getMax().asNode());
    }

    default public <T extends Comparable<T>> Range<T> toRange(Class<T> clazz) {
        Comparable min = (Comparable)this.getMin(clazz);
        boolean isMinInclusive = this.isMinInclusive();
        Comparable max = (Comparable)this.getMax(clazz);
        boolean isMaxInclusive = this.isMaxInclusive();
        Range<Comparable> result = RangeSpec.createRange(min, isMinInclusive, max, isMaxInclusive);
        return result;
    }

    public static <T extends Comparable<T>> Range<T> createRange(T min, boolean isMinInclusive, T max, boolean isMaxInclusive) {
        BoundType maxBoundType;
        BoundType minBoundType = isMinInclusive ? BoundType.CLOSED : BoundType.OPEN;
        BoundType boundType = maxBoundType = isMaxInclusive ? BoundType.CLOSED : BoundType.OPEN;
        Range result = min == null ? (max == null ? Range.all() : Range.upTo(max, (BoundType)maxBoundType)) : (max == null ? Range.downTo(min, (BoundType)minBoundType) : Range.range(min, (BoundType)minBoundType, max, (BoundType)maxBoundType));
        return result;
    }

    public static <T extends Comparable<T>> Range<T> createRange(T min, BoundType minBoundType, T max, BoundType maxBoundType) {
        Range result = min == null ? (max == null ? Range.all() : Range.upTo(max, (BoundType)maxBoundType)) : (max == null ? Range.downTo(min, (BoundType)minBoundType) : Range.range(min, (BoundType)minBoundType, max, (BoundType)maxBoundType));
        return result;
    }
}

