/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.facete.treequery2.impl;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.aksw.commons.collections.generator.Generator;
import org.aksw.jenax.arq.util.node.NodeTransformLib2;
import org.aksw.jenax.path.core.FacetStep;
import org.aksw.jenax.sparql.fragment.api.Fragment;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Var;

public class FacetRelationUtils {
    public static Map<Var, Node> createVarToComponentMap(Fragment relation) {
        List<Node> components = Arrays.asList(FacetStep.SOURCE, FacetStep.PREDICATE, FacetStep.TARGET);
        Map<Var, Node> result = components.stream().map(c -> new AbstractMap.SimpleEntry<Var, Node>(FacetRelationUtils.resolveComponent(c, relation), (Node)c)).filter(e -> e.getKey() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return result;
    }

    public static Var resolveComponent(Node component, Fragment relation) {
        Var o;
        Var p;
        Var s;
        List vars = relation.getVars();
        int n = vars.size();
        if (n == 1) {
            Object g = null;
            s = (Var)vars.get(0);
            p = null;
            o = (Var)vars.get(0);
        } else if (n == 2) {
            Object g = null;
            s = (Var)vars.get(0);
            p = null;
            o = (Var)vars.get(1);
        } else if (n == 3) {
            Object g = null;
            s = (Var)vars.get(0);
            p = (Var)vars.get(1);
            o = (Var)vars.get(2);
        } else {
            throw new RuntimeException("Binary or ternary relation expected");
        }
        Var result = null;
        if (FacetStep.isSource((Node)component)) {
            result = s;
        } else if (FacetStep.isTarget((Node)component)) {
            result = o;
        } else if (FacetStep.isPredicate((Node)component)) {
            result = p;
        }
        return result;
    }

    public static Map<Var, Var> createVarMap(Fragment relation, Var originalSubjectVar, Var renamedSubjectVar, String scopePrefix, Set<Var> forbiddenVars) {
        Set vars = relation.getVarsMentioned();
        vars.remove(originalSubjectVar);
        HashMap<Var, Var> map = new HashMap<Var, Var>();
        map.put(originalSubjectVar, renamedSubjectVar);
        for (Var v : vars) {
            Var vv = (Var)Generator.create((String)(scopePrefix + v.getName())).map(Var::alloc).filterDrop(forbiddenVars::contains).next();
            map.put(v, vv);
        }
        return map;
    }

    public static Fragment applyNodeTransform(Fragment relation, Map<Var, Var> map) {
        Fragment result = relation.applyNodeTransform(NodeTransformLib2.wrapWithNullAsIdentity(map::get));
        return result;
    }

    public static Fragment renameVariables(Fragment relation, Var originalSubjectVar, Var renamedSubjectVar, String scopePrefix, Set<Var> forbiddenVars) {
        Map<Var, Var> map = FacetRelationUtils.createVarMap(relation, originalSubjectVar, renamedSubjectVar, scopePrefix, forbiddenVars);
        Fragment result = FacetRelationUtils.applyNodeTransform(relation, map);
        return result;
    }
}

