/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.facete.v4.impl;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Collection;
import java.util.function.Supplier;
import org.aksw.commons.util.cache.CacheUtils;
import org.aksw.facete.v3.api.FacetConstraint;
import org.aksw.facete.v3.api.FacetNode;
import org.aksw.facete.v3.api.FacetedQuery;
import org.aksw.facete.v3.api.TreeQueryNode;
import org.aksw.facete.v4.impl.FacetNodeImpl;
import org.aksw.facete.v4.impl.FacetedRelationQuery;
import org.aksw.jenax.dataaccess.sparql.datasource.RDFDataSource;
import org.aksw.jenax.sparql.fragment.api.Fragment;
import org.aksw.jenax.sparql.fragment.api.Fragment1;
import org.aksw.jenax.sparql.fragment.impl.Concept;
import org.apache.jena.sparql.core.Var;

public class FacetedQueryImpl
implements FacetedQuery {
    protected RDFDataSource dataSource;
    protected FacetedRelationQuery relationQuery;
    protected Var baseVar;
    protected TreeQueryNode focus;
    protected Cache<TreeQueryNode, FacetNode> viewCache = CacheBuilder.newBuilder().maximumSize(1000L).build();

    public FacetedQueryImpl(FacetedRelationQuery relationQuery, Var baseVar, TreeQueryNode focus) {
        this.relationQuery = relationQuery;
        this.baseVar = baseVar;
        this.focus = focus;
    }

    public Var getBaseVar() {
        return this.baseVar;
    }

    public FacetedRelationQuery relationQuery() {
        return this.relationQuery;
    }

    FacetNode wrapNode(TreeQueryNode node) {
        return (FacetNode)CacheUtils.get(this.viewCache, (Object)node, () -> new FacetNodeImpl(this, node));
    }

    public FacetNode root() {
        return this.wrapNode(this.focus);
    }

    public FacetNode focus() {
        return this.wrapNode(this.focus);
    }

    public void focus(FacetNode node) {
        Preconditions.checkArgument((node.query() == this ? 1 : 0) != 0, (Object)"Facet Node must belong to this query");
        this.focus = ((FacetNodeImpl)node).node;
    }

    public Concept toConcept() {
        return null;
    }

    public Collection<FacetConstraint> constraints() {
        return null;
    }

    public FacetedQuery baseConcept(Supplier<? extends Fragment1> conceptSupplier) {
        return null;
    }

    public FacetedQuery baseConcept(Fragment1 concept) {
        return null;
    }

    public Fragment1 baseConcept() {
        Var rootVar = (Var)this.relationQuery.varToRoot.inverse().get((Object)this.focus);
        Fragment r = this.relationQuery.baseRelation.get();
        return r.project(new Var[]{rootVar}).toFragment1();
    }

    public RDFDataSource dataSource() {
        return this.dataSource;
    }

    public FacetedQuery dataSource(RDFDataSource dataSource) {
        this.dataSource = dataSource;
        return this;
    }
}

