/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.facete.v3.impl;

import com.google.common.collect.Range;
import java.util.Optional;
import org.aksw.commons.util.range.CountInfo;
import org.aksw.facete.v3.api.FacetCount;
import org.aksw.jena_sparql_api.data_query.impl.CountUtils;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.impl.ResourceImpl;
import org.hobbit.benchmark.faceted_browsing.v2.domain.Vocab;

public class FacetCountImpl
extends ResourceImpl
implements FacetCount {
    public FacetCountImpl(Node n, EnhGraph m) {
        super(n, m);
    }

    public Node getPredicate() {
        return this.asNode();
    }

    public CountInfo getDistinctValueCount() {
        Long min;
        Long max = min = (Long)Optional.ofNullable(this.getProperty(Vocab.facetCount)).map(Statement::getLong).orElse(null);
        if (min == null) {
            throw new RuntimeException("Should not happen");
        }
        Range range = max == null ? Range.atLeast((Comparable)min) : Range.closed((Comparable)min, (Comparable)max);
        CountInfo result = CountUtils.toCountInfo((Range<Long>)range);
        return result;
    }

    public String toString() {
        return "FacetCountImpl [" + String.valueOf(this.getPredicate()) + ": " + String.valueOf(this.getDistinctValueCount()) + "]";
    }
}

