/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.facete.v3.experimental;

import java.util.Collection;
import org.aksw.facete.v3.api.FacetedQuery;
import org.aksw.facete.v3.api.path.Resolver;
import org.aksw.facete.v3.experimental.PathDirNode;
import org.aksw.facete.v3.experimental.ResolverMultiNodeImpl;
import org.aksw.facete.v3.experimental.ResolverNodeImpl;
import org.aksw.facete.v3.impl.FacetedQueryBuilder;
import org.aksw.jena_sparql_api.algebra.utils.VirtualPartitionedQuery;
import org.aksw.jena_sparql_api.data_query.api.DataQuery;
import org.aksw.jena_sparql_api.data_query.api.ResolverDirNode;
import org.aksw.jena_sparql_api.data_query.api.ResolverMultiNode;
import org.aksw.jena_sparql_api.data_query.api.ResolverNode;
import org.aksw.jenax.dataaccess.sparql.connection.query.SparqlQueryConnectionTmp;
import org.aksw.jenax.path.core.FacetStep;
import org.aksw.jenax.sparql.fragment.api.Fragment3;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdfconnection.SparqlQueryConnection;
import org.apache.jena.sparql.core.Transactional;

public class ResolverDirNodeImpl
extends PathDirNode<ResolverNode, ResolverMultiNode>
implements ResolverDirNode {
    protected Resolver resolver;
    protected DataQuery<?> conn;

    public ResolverDirNodeImpl(ResolverNodeImpl parent, boolean isFwd, DataQuery<?> conn) {
        super(parent, isFwd);
        this.resolver = parent.getResolver();
        this.isFwd = isFwd;
        this.conn = conn;
    }

    public Resolver getResolver() {
        return this.resolver;
    }

    public Collection<Fragment3> getContrib() {
        Collection result = this.resolver.getRdfGraphSpec(this.isFwd);
        return result;
    }

    @Override
    protected ResolverMultiNodeImpl viaImpl(Resource property, Node component) {
        if (component != null && !FacetStep.isTarget((Node)component)) {
            throw new UnsupportedOperationException("Support for referencing components not implemented");
        }
        return new ResolverMultiNodeImpl(this, property, this.conn);
    }

    public Query rewrite(Query query) {
        Collection<Fragment3> views = this.getContrib();
        Query result = VirtualPartitionedQuery.rewrite(views, (Query)query);
        return result;
    }

    public SparqlQueryConnection virtualConn() {
        SparqlQueryConnectionTmp result = new SparqlQueryConnectionTmp(){

            public Transactional getDelegate() {
                return null;
            }

            public void close() {
            }

            public QueryExecution query(Query query) {
                System.out.println("Got query: " + String.valueOf(query));
                SparqlQueryConnection c = ResolverDirNodeImpl.this.conn.connection();
                Query rewritten = ResolverDirNodeImpl.this.rewrite(query);
                System.out.println("Rewritten query: " + String.valueOf(rewritten));
                QueryExecution result = c.query(rewritten);
                return result;
            }
        };
        return result;
    }

    public FacetedQuery toFacetedQuery() {
        SparqlQueryConnection virtualConn = this.virtualConn();
        FacetedQuery result = ((FacetedQueryBuilder)FacetedQueryBuilder.builder().configDataConnection().setSource((Object)virtualConn).end()).create();
        return result;
    }
}

