/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.data_query.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.aksw.commons.collections.generator.Generator;
import org.aksw.jena_sparql_api.data_query.api.PathAccessorRdf;
import org.aksw.jenax.arq.util.syntax.ElementUtils;
import org.aksw.jenax.arq.util.var.VarGeneratorBlacklist;
import org.aksw.jenax.arq.util.var.VarUtils;
import org.aksw.jenax.arq.util.var.Vars;
import org.aksw.jenax.sparql.fragment.api.Fragment2;
import org.aksw.jenax.sparql.fragment.impl.Concept;
import org.aksw.jenax.sparql.fragment.impl.Fragment2Impl;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.aggregate.AggCountVarDistinct;
import org.apache.jena.sparql.expr.aggregate.Aggregator;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.ElementTriplesBlock;
import org.apache.jena.sparql.syntax.Template;

public class QueryFragment {
    protected Var conceptVar;
    protected Query query;
    public static Property facetCount = ResourceFactory.createProperty((String)"http://example.org/facetCount");

    public QueryFragment(Var conceptVar, Query query) {
        this.conceptVar = conceptVar;
        this.query = query;
    }

    public String toString() {
        return "QueryFragment [conceptVar=" + String.valueOf(this.conceptVar) + ", query=" + String.valueOf(this.query) + "]";
    }

    public static Triple createTriple(boolean isReverse, Node s, Node p, Node o) {
        Triple result = isReverse ? Triple.create((Node)o, (Node)p, (Node)s) : Triple.create((Node)s, (Node)p, (Node)o);
        return result;
    }

    public static QueryFragment createForPredicate(Node p, boolean isReverse) {
        Triple t = QueryFragment.createTriple(isReverse, (Node)Vars.s, p, (Node)Vars.o);
        BasicPattern bgp = new BasicPattern();
        bgp.add(t);
        Query query = new Query();
        query.setConstructTemplate(new Template(bgp));
        query.setQueryPattern((Element)new ElementTriplesBlock(bgp));
        QueryFragment result = new QueryFragment(Vars.s, query);
        return result;
    }

    public static void extractFacetConstraints(Query query) {
    }

    public static <P> void toElement(Iterable<P> paths, PathAccessorRdf<P> accessor, Set<Element> elements, Map<P, Fragment2> pathToNode, Set<Var> forbiddenVars, Generator<Var> varGen) {
        for (P path : paths) {
            QueryFragment.toElement(path, accessor, pathToNode, forbiddenVars, varGen);
        }
    }

    public static <P> Var getOrCreateAlias(P path, PathAccessorRdf<P> accessor, Map<P, Fragment2> pathToNode, Set<Var> forbiddenVars, Generator<Var> varGen) {
        varGen = VarGeneratorBlacklist.create(varGen, forbiddenVars);
        String tmp = accessor.getAlias(path);
        if (tmp == null) {
            Object parent = accessor.getParent(path);
            Fragment2 br = pathToNode.get(path);
            tmp = br != null ? br.getTargetVar().getName() : ((Var)varGen.next()).getName();
        }
        Var result = Var.alloc((String)tmp);
        return result;
    }

    public static <P> Fragment2 toElement(P path, PathAccessorRdf<P> accessor, Map<P, Fragment2> pathToNode, Set<Var> forbiddenVars, Generator<Var> varGen) {
        Fragment2 result = pathToNode.get(path);
        if (result == null) {
            Object parentPath = accessor.getParent(path);
            if (parentPath == null) {
                Var s = QueryFragment.getOrCreateAlias(path, accessor, pathToNode, forbiddenVars, varGen);
                result = new Fragment2Impl((Element)new ElementGroup(), s, s);
            } else {
                Fragment2 parentSegment = QueryFragment.toElement(parentPath, accessor, pathToNode, forbiddenVars, varGen);
                Var s = parentSegment.getTargetVar();
                Var o = QueryFragment.getOrCreateAlias(path, accessor, pathToNode, forbiddenVars, varGen);
                Fragment2 br = accessor.getReachingRelation(path);
                Set vars = br.getVarsMentioned();
                vars.remove(br.getSourceVar());
                vars.remove(br.getTargetVar());
                Map map = VarUtils.createDistinctVarMap(forbiddenVars, (Collection)vars, (boolean)false, varGen);
                map.put(br.getSourceVar(), s);
                map.put(br.getTargetVar(), o);
                Element segment = ElementUtils.createRenamedElement((Element)br.getElement(), (Map)map);
                result = new Fragment2Impl(segment, s, o);
            }
            pathToNode.put(path, result);
        }
        return result;
    }

    public static void aggregate(QueryFragment queryFragment, Path path, Aggregator agg) {
    }

    public static QueryFragment createForFacetCountRemainder(Concept concept, boolean isReverse) {
        Query query = new Query();
        VarGeneratorBlacklist varGen = VarGeneratorBlacklist.create((String)"v", (Collection)concept.getVarsMentioned());
        Var s = concept.getVar();
        Var p = (Var)varGen.next();
        Var o = (Var)varGen.next();
        Var c = (Var)varGen.next();
        BasicPattern bgp = new BasicPattern();
        bgp.add(Triple.create((Node)p, (Node)facetCount.asNode(), (Node)c));
        Template template = new Template(bgp);
        query.setConstructTemplate(template);
        VarExprList proj = query.getProject();
        proj.add(p);
        query.allocAggregate((Aggregator)new AggCountVarDistinct((Expr)new ExprVar(Vars.o)));
        ArrayList<ElementTriplesBlock> elts = new ArrayList<ElementTriplesBlock>();
        elts.addAll(concept.getElements());
        elts.add(ElementUtils.createElement((Triple)QueryFragment.createTriple(isReverse, (Node)s, (Node)p, (Node)o)));
        Element queryPattern = ElementUtils.groupIfNeeded(elts);
        query.setQueryPattern(queryPattern);
        query.addGroupBy((Node)p);
        QueryFragment result = new QueryFragment(o, query);
        return result;
    }
}

