/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.data_query.impl;

import com.google.common.collect.Range;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.aksw.commons.util.range.CountInfo;
import org.aksw.jenax.sparql.fragment.api.Fragment2;
import org.aksw.jenax.sparql.fragment.api.Fragment3;
import org.aksw.jenax.sparql.fragment.impl.Fragment2Impl;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Var;

public class CountUtils {
    public static CountInfo toCountInfo(Range<Long> range) {
        if (!range.hasLowerBound()) {
            throw new IllegalArgumentException("Range must have a lower bound");
        }
        long lowerBound = (Long)range.lowerEndpoint();
        boolean hasMoreItems = !range.hasUpperBound() || lowerBound != (Long)range.upperEndpoint();
        CountInfo result = new CountInfo(lowerBound, hasMoreItems, null);
        return result;
    }

    public static Map<Node, Fragment2> createQueriesPreCountCore(Map<Node, Fragment2> overrides, Fragment3 defaultRelation, Var countVar, Collection<Node> properties) {
        HashMap<Node, Fragment2> result = new HashMap<Node, Fragment2>();
        for (Node p : properties) {
            Fragment2 r = overrides.get(p);
            if (r == null) {
                Object tr = null;
                Fragment2Impl br = new Fragment2Impl(tr.getElement(), tr.getS(), tr.getO());
                result.put(p, (Fragment2)br);
                continue;
            }
            result.put(p, r);
        }
        return result;
    }
}

