/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.facete.v4.impl;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.aksw.facete.v4.impl.PropertyResolver;
import org.aksw.jenax.arq.datashape.viewselector.EntityClassifier;
import org.aksw.jenax.arq.util.node.NodeTransformLib2;
import org.aksw.jenax.arq.util.node.NodeUtils;
import org.aksw.jenax.arq.util.syntax.ElementUtils;
import org.aksw.jenax.arq.util.var.Vars;
import org.aksw.jenax.sparql.fragment.api.Fragment;
import org.aksw.jenax.sparql.fragment.api.Fragment2;
import org.aksw.jenax.sparql.fragment.impl.Fragment2Impl;
import org.aksw.jenax.sparql.fragment.impl.Fragment3Impl;
import org.aksw.jenax.sparql.fragment.impl.FragmentUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.E_Function;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementBind;
import org.apache.jena.sparql.syntax.ElementSubQuery;
import org.apache.jena.sparql.syntax.ElementTriplesBlock;
import org.topbraid.shacl.model.SHFactory;

public class PropertyResolverImpl
implements PropertyResolver {
    public static final Property virtualPropertyDefinition = ResourceFactory.createProperty((String)"https://w3id.org/aksw/norse#sparqlElement");
    private static Dataset virtualProperties = null;
    protected int nextPropertyId = 0;
    protected Map<String, Fragment2> iriToRelation = new LinkedHashMap<String, Fragment2>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Dataset getVirtualProperties() {
        if (virtualProperties != null) return virtualProperties;
        Class<PropertyResolverImpl> clazz = PropertyResolverImpl.class;
        synchronized (PropertyResolverImpl.class) {
            if (virtualProperties != null) return virtualProperties;
            virtualProperties = RDFDataMgr.loadDataset((String)"virtual-properties.ttl");
            // ** MonitorExit[var0] (shouldn't be in output)
            return virtualProperties;
        }
    }

    @Override
    public Fragment resolve(Node property) {
        String fnPrefix;
        String str;
        Fragment2 result = null;
        if (NodeUtils.ANY_IRI.equals((Object)property)) {
            result = new Fragment3Impl((Element)ElementUtils.createElementTriple((Node)Vars.s, (Node)Vars.p, (Node)Vars.o), Vars.s, Vars.p, Vars.o);
        }
        if (result == null && property.isURI() && (str = property.getURI()).startsWith(fnPrefix = "fn:")) {
            String fnIri = str.substring(fnPrefix.length());
            ElementBind elt = new ElementBind(Vars.o, (Expr)new E_Function(fnIri, new ExprList((Expr)new ExprVar(Vars.s))));
            result = new Fragment2Impl((Element)elt, Vars.s, Vars.o);
        }
        if (result == null) {
            Query query;
            Element elt;
            Resource r;
            String definition;
            Fragment2 relation = null;
            Model model = PropertyResolverImpl.getVirtualProperties().getDefaultModel();
            RDFNode rdfNode = model.asRDFNode(property);
            if (rdfNode != null && rdfNode.isResource() && (definition = (String)Optional.ofNullable((r = rdfNode.asResource()).getProperty(virtualPropertyDefinition)).map(Statement::getString).orElse(null)) != null && (elt = (result = (relation = FragmentUtils.fromQuery((Query)(query = QueryFactory.create((String)definition))).toFragment2()).toFragment2()).getElement()) instanceof ElementSubQuery) {
                elt = ((ElementSubQuery)result).getQuery().getQueryPattern();
                result = new Fragment2Impl(elt, relation.getSourceVar(), relation.getTargetVar());
            }
        }
        if (result == null) {
            result = Fragment2Impl.create((Node)property);
        }
        return result;
    }

    public void put(String iri, Fragment2 relation) {
        this.iriToRelation.put(iri, relation);
    }

    public Element resolve(Var parentVar, Node predicateNode, Var targetVar, boolean isFwd) {
        return PropertyResolverImpl.createElementFromConcretePredicate(parentVar, predicateNode, targetVar, isFwd);
    }

    public static void testLoadShacl() {
        SHFactory.ensureInited();
        Model shaclModel = RDFDataMgr.loadModel((String)"test.r2rml.core.shacl.ttl");
        EntityClassifier entityClassifier = new EntityClassifier(Vars.s);
        EntityClassifier.registerNodeShapes((EntityClassifier)entityClassifier, (Model)shaclModel);
        Fragment r = entityClassifier.createClassifyingRelation();
        Query query = r.toQuery();
        PropertyResolverImpl.getVirtualProperties().getDefaultModel().createResource("urn:shaclShape").addProperty(virtualPropertyDefinition, query.toString());
    }

    public String allocate(Path path) {
        Fragment2 relation = Fragment2Impl.create((Path)path);
        String iri = "urn:x-jenax:custom-property-" + this.nextPropertyId++;
        this.put(iri, relation);
        return iri;
    }

    public static Element createElementFromConcretePredicate(Var parentVar, Node predicateNode, Var targetVar, boolean isFwd) {
        ElementTriplesBlock result = null;
        if (predicateNode.isURI()) {
            String fnPrefix;
            String str = predicateNode.getURI();
            if (str.startsWith(fnPrefix = "fn:")) {
                String fnIri = str.substring(fnPrefix.length());
                result = new ElementBind(targetVar, (Expr)new E_Function(fnIri, new ExprList((Expr)new ExprVar(parentVar))));
            }
            if (result == null) {
                Resource r;
                String definition;
                Fragment2 relation = null;
                Model model = PropertyResolverImpl.getVirtualProperties().getDefaultModel();
                RDFNode rdfNode = model.asRDFNode(predicateNode);
                if (rdfNode != null && rdfNode.isResource() && (definition = (String)Optional.ofNullable((r = rdfNode.asResource()).getProperty(virtualPropertyDefinition)).map(Statement::getString).orElse(null)) != null) {
                    Query query = QueryFactory.create((String)definition);
                    relation = FragmentUtils.fromQuery((Query)query).toFragment2();
                    Fragment2 br = relation.toFragment2();
                    HashMap<Var, Var> remap = new HashMap<Var, Var>();
                    remap.put(br.getSourceVar(), parentVar);
                    remap.put(br.getTargetVar(), targetVar);
                    br = br.applyNodeTransform(NodeTransformLib2.wrapWithNullAsIdentity(remap::get));
                    result = br.getElement();
                    result = ElementUtils.flatten((Element)result);
                    if (result instanceof ElementSubQuery) {
                        result = ((ElementSubQuery)result).getQuery().getQueryPattern();
                    }
                }
            }
        }
        if (result == null) {
            result = ElementUtils.createElementTriple((Node)parentVar, (Node)predicateNode, (Node)targetVar, (boolean)isFwd);
        }
        return result;
    }
}

