/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.facete.v3.api;

import com.google.common.collect.Iterators;
import com.google.common.collect.Range;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.aksw.facete.v3.api.FacetConstraintControl;
import org.aksw.facete.v3.api.HLFacetConstraint;
import org.aksw.jenax.arq.util.node.ComparableNodeValue;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.WrappedIterator;

public interface ConstraintFacade<B> {
    public Collection<FacetConstraintControl> list();

    public Collection<HLFacetConstraint<? extends ConstraintFacade<B>>> listHl();

    default public Stream<FacetConstraintControl> stream() {
        return this.list().stream();
    }

    public HLFacetConstraint<? extends ConstraintFacade<B>> eq(Node var1);

    public HLFacetConstraint<? extends ConstraintFacade<B>> exists();

    public HLFacetConstraint<? extends ConstraintFacade<B>> absent();

    public HLFacetConstraint<? extends ConstraintFacade<B>> gt(Node var1);

    public HLFacetConstraint<? extends ConstraintFacade<B>> lt(Node var1);

    public HLFacetConstraint<? extends ConstraintFacade<B>> neq(Node var1);

    public HLFacetConstraint<? extends ConstraintFacade<B>> nodeRange(Range<ComparableNodeValue> var1);

    public HLFacetConstraint<? extends ConstraintFacade<B>> range(Range<?> var1);

    public Expr thisAsExpr();

    default public boolean hasExpr(Expr expr) {
        boolean result = this.listHl().stream().map(HLFacetConstraint::expr).filter(e -> Objects.equals(expr, e)).findFirst().isPresent();
        return result;
    }

    default public boolean removeExpr(Expr expr) {
        ExtendedIterator it = WrappedIterator.create(this.listHl().iterator()).mapWith(HLFacetConstraint::expr);
        boolean result = Iterators.removeAll((Iterator)it, Collections.singleton(expr));
        return result;
    }

    public HLFacetConstraint<? extends ConstraintFacade<B>> createConstraint(Expr var1);

    default public HLFacetConstraint<? extends ConstraintFacade<B>> getOrCreateConstraint(Expr expr) {
        List list = this.findConstraintByExpr(expr).toList();
        HLFacetConstraint result = list.isEmpty() ? this.createConstraint(expr) : (HLFacetConstraint)list.iterator().next();
        return result;
    }

    default public ExtendedIterator<HLFacetConstraint<? extends ConstraintFacade<B>>> findConstraintByExpr(Expr expr) {
        ExtendedIterator result = WrappedIterator.create(this.listHl().iterator()).filterKeep(e -> Objects.equals(expr, e.expr()));
        return result;
    }

    default public boolean toggle(Expr expr) {
        boolean alreadySet = this.hasExpr(expr);
        if (!alreadySet) {
            HLFacetConstraint<ConstraintFacade<B>> constraint = this.createConstraint(expr);
            this.listHl().add(constraint);
        } else {
            this.removeExpr(expr);
        }
        return !alreadySet;
    }

    default public HLFacetConstraint<? extends ConstraintFacade<B>> eqIri(String iriStr) {
        return this.eq(NodeFactory.createURI((String)iriStr));
    }

    default public HLFacetConstraint<? extends ConstraintFacade<B>> regex(String pattern) {
        return this.regex(pattern, "i");
    }

    public HLFacetConstraint<? extends ConstraintFacade<B>> regex(String var1, String var2);

    default public HLFacetConstraint<? extends ConstraintFacade<B>> eqStr(String stringLiteral) {
        return this.eq(NodeFactory.createLiteral((String)stringLiteral));
    }

    default public HLFacetConstraint<? extends ConstraintFacade<B>> eq(RDFNode rdfNode) {
        return this.eq(rdfNode.asNode());
    }

    @Deprecated
    public B end();

    default public B leaveConstraints() {
        return this.end();
    }
}

