/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.facete.v3.api.path;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aksw.commons.collections.collectors.CollectorUtils;
import org.aksw.facete.v3.api.path.NestedVarMap;
import org.apache.jena.sparql.core.Var;

public class NestedVarMapImpl
implements NestedVarMap {
    protected Map<Var, Var> localToFinalVarMap;
    protected Map<String, NestedVarMap> memberVarMap;
    protected Set<Var> fixedFinalVars;

    public NestedVarMapImpl(Map<Var, Var> localToFinalVarMap, Set<Var> fixedFinalVars) {
        this(localToFinalVarMap, fixedFinalVars, Collections.emptyMap());
    }

    public NestedVarMapImpl(Map<Var, Var> localToFinalVarMap, Set<Var> fixedFinalVars, Map<String, NestedVarMap> memberVarMap) {
        this.localToFinalVarMap = localToFinalVarMap;
        this.memberVarMap = memberVarMap;
        this.fixedFinalVars = fixedFinalVars;
    }

    @Override
    public Set<Var> getVarsMentioned() {
        Set<Var> result = Stream.concat(this.localToFinalVarMap.values().stream(), this.memberVarMap.values().stream().flatMap(x -> x.getVarsMentioned().stream())).collect(Collectors.toSet());
        return result;
    }

    @Override
    public NestedVarMap get(String alias) {
        NestedVarMap result = this.memberVarMap.get(alias);
        return result;
    }

    @Override
    public Set<Var> getFixedFinalVars() {
        return this.fixedFinalVars;
    }

    @Override
    public Map<Var, Var> getLocalToFinalVarMap() {
        return this.localToFinalVarMap;
    }

    @Override
    public Map<String, NestedVarMap> getMemberVarMap() {
        return this.memberVarMap;
    }

    @Override
    public void transformValues(Function<? super Var, ? extends Var> fn) {
        for (Map.Entry<Var, Var> e : this.localToFinalVarMap.entrySet()) {
            Var before = e.getValue();
            Var after = fn.apply((Var)before);
            e.setValue(after);
        }
        for (NestedVarMap child : this.memberVarMap.values()) {
            child.transformValues(fn);
        }
        Collection tmp = this.fixedFinalVars.stream().map(fn::apply).collect(Collectors.toList());
        this.fixedFinalVars.clear();
        this.fixedFinalVars.addAll(tmp);
    }

    @Override
    public NestedVarMapImpl clone() {
        LinkedHashMap<Var, Var> cp1 = new LinkedHashMap<Var, Var>(this.localToFinalVarMap);
        LinkedHashSet<Var> cp2 = new LinkedHashSet<Var>(this.fixedFinalVars);
        Map cp3 = (Map)this.memberVarMap.entrySet().stream().collect(CollectorUtils.toLinkedHashMap(Map.Entry::getKey, e -> ((NestedVarMap)e.getValue()).clone()));
        NestedVarMapImpl result = new NestedVarMapImpl(cp1, cp2, cp3);
        return result;
    }

    public String toString() {
        return "NestedVarMap [localToFinalVarMap=" + String.valueOf(this.localToFinalVarMap) + ", memberVarMap=" + String.valueOf(this.memberVarMap) + "]";
    }
}

