/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.facete.v3.bgp.utils;

import java.util.Objects;
import java.util.Optional;
import org.aksw.facete.v3.bgp.api.BgpMultiNode;
import org.aksw.facete.v3.bgp.api.BgpNode;
import org.aksw.jena_sparql_api.data_query.api.PathAccessor;
import org.aksw.jenax.arq.util.syntax.ElementUtils;
import org.aksw.jenax.sparql.fragment.api.Fragment2;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.vocabulary.RDF;
import org.hobbit.benchmark.faceted_browsing.v2.domain.Vocab;

public class PathAccessorImpl
implements PathAccessor<BgpNode> {
    protected Model model;

    public PathAccessorImpl() {
        this((Model)null);
    }

    public PathAccessorImpl(RDFNode rdfNode) {
        this.model = rdfNode.getModel();
    }

    public PathAccessorImpl(Model model) {
        this.model = model;
    }

    @Override
    public Class<BgpNode> getPathClass() {
        return BgpNode.class;
    }

    @Override
    public BgpNode getParent(BgpNode path) {
        BgpNode result = Optional.ofNullable(path.parent()).map(BgpMultiNode::parent).orElse(null);
        return result;
    }

    @Override
    public Fragment2 getReachingRelation(BgpNode path) {
        Fragment2 result = BgpNode.getReachingRelation(path);
        return result;
    }

    @Override
    public boolean isReverse(BgpNode path) {
        Fragment2 br = this.getReachingRelation(path);
        Element brE = br.getElement();
        Triple t = Objects.requireNonNull(ElementUtils.extractTriple((Element)brE));
        boolean result = !br.getSourceVar().equals((Object)t.getSubject());
        return result;
    }

    @Override
    public String getPredicate(BgpNode path) {
        Fragment2 br = this.getReachingRelation(path);
        Triple t = ElementUtils.extractTriple((Element)br.getElement());
        Node node = t == null ? null : t.getPredicate();
        String result = node == null ? null : node.getURI();
        return result;
    }

    @Override
    public String getAlias(BgpNode path) {
        return path.alias();
    }

    @Override
    public BgpNode tryMapToPath(Node node) {
        Objects.requireNonNull(this.model, "Testing whether a node denotes a path object requires a model to test against, but none was set.");
        BgpNode result = null;
        if (node.isBlank()) {
            BgpNode state = (BgpNode)this.model.wrapAsResource(node).as(BgpNode.class);
            boolean isBgpNode = state.hasProperty(RDF.type, (RDFNode)Vocab.BgpNode);
            result = isBgpNode ? state : null;
        }
        return result;
    }
}

