/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.facete.v3.api;

import com.google.common.annotations.Beta;
import com.google.common.collect.Streams;
import com.google.common.graph.Traverser;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.aksw.commons.path.core.Path;
import org.aksw.commons.util.Directed;
import org.aksw.facete.v3.api.Castable;
import org.aksw.facete.v3.api.ConstraintFacade;
import org.aksw.facete.v3.api.Direction;
import org.aksw.facete.v3.api.FacetDirNode;
import org.aksw.facete.v3.api.FacetMultiNode;
import org.aksw.facete.v3.api.FacetedDataQuery;
import org.aksw.facete.v3.api.FacetedQuery;
import org.aksw.facete.v3.api.traversal.TraversalNode;
import org.aksw.jenax.path.core.FacetPath;
import org.aksw.jenax.path.core.FacetPathOps;
import org.aksw.jenax.path.core.FacetStep;
import org.aksw.jenax.sparql.fragment.api.Fragment2;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.sparql.core.Var;

public interface FacetNode
extends TraversalNode<FacetNode, FacetDirNode, FacetMultiNode>,
Castable {
    default public FacetNode traverse(FacetPath path) {
        return FacetNode.goTo(this, path);
    }

    public static FacetNode goTo(FacetNode start, FacetPath path) {
        FacetNode current = path.isAbsolute() ? start.root() : start;
        for (FacetStep step : path.getSegments()) {
            Direction dir = Direction.ofFwd(step.isForward());
            Node node = step.getNode();
            FacetMultiNode fmn = (FacetMultiNode)current.step(node, dir);
            String alias = step.getAlias();
            if (alias == null || alias.isEmpty()) {
                current = (FacetNode)fmn.one();
                continue;
            }
            current = (FacetNode)fmn.viaAlias(alias);
        }
        return current;
    }

    default public List<Directed<FacetNode>> path() {
        List<Directed<FacetNode>> result = Streams.stream((Iterable)Traverser.forTree(x -> Optional.ofNullable(x.parent()).map(Collections::singleton).orElse(Collections.emptySet())).depthFirstPostOrder((Object)this)).filter(x -> x.parent() != null).map(x -> new Directed(x, x.reachingDirection().isBackward())).collect(Collectors.toList());
        return result;
    }

    default public FacetPath facetPath() {
        List<Directed<FacetNode>> list = this.path();
        List steps = list.stream().map(dfn -> {
            boolean isFwd = dfn.isForward();
            FacetNode fn = (FacetNode)dfn.getValue();
            FacetStep step = fn.reachingFacetStep();
            if (!isFwd) {
                step = step.toggleDirection();
            }
            return step;
        }).collect(Collectors.toList());
        return FacetPath.newAbsolutePath(steps);
    }

    public FacetedQuery query();

    @Beta
    public FacetNode chRoot();

    @Beta
    public FacetNode chFocus();

    public FacetNode as(String var1);

    public FacetNode as(Var var1);

    public Var alias();

    public FacetNode parent();

    public Direction reachingDirection();

    public Node reachingPredicate();

    public String reachingAlias();

    public Node targetComponent();

    default public FacetStep reachingFacetStep() {
        Direction d = this.reachingDirection();
        Node p = this.reachingPredicate();
        String a = this.reachingAlias();
        Node c = this.targetComponent();
        Var cc = c == null ? FacetStep.TARGET : c;
        FacetStep result = FacetStep.of((Node)p, (org.aksw.commons.util.direction.Direction)org.aksw.commons.util.direction.Direction.ofFwd((boolean)d.isForward), (String)a, (Node)cc);
        return result;
    }

    default public FacetNode resolve(Path<FacetStep> facetPath) {
        FacetNode tmp = facetPath.isAbsolute() ? this.root() : this;
        for (FacetStep step : facetPath.getSegments()) {
            if (FacetPathOps.PARENT.equals((Object)step)) {
                tmp = tmp.parent();
                continue;
            }
            if (FacetPathOps.SELF.equals((Object)step)) continue;
            tmp = (FacetNode)tmp.step(step);
        }
        return tmp;
    }

    public Fragment2 getReachingRelation();

    public FacetNode root();

    public ConstraintFacade<? extends FacetNode> enterConstraints();

    public FacetedDataQuery<RDFNode> availableValues();

    public FacetedDataQuery<RDFNode> remainingValues();
}

