/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.relationlet;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aksw.facete.v3.api.path.NestedVarMap;
import org.aksw.jena_sparql_api.relationlet.RelationletSimple;
import org.aksw.jena_sparql_api.relationlet.VarRefStatic;
import org.apache.jena.sparql.core.Var;

public interface Relationlet {
    public Collection<Var> getExposedVars();

    public Set<Var> getVarsMentioned();

    default public boolean isPinned(Var var) {
        Set<Var> pinnedVars = this.getPinnedVars();
        boolean result = pinnedVars.contains(var);
        return result;
    }

    default public Relationlet pinVar(Var var) {
        return this.setPinnedVar(var, true);
    }

    default public Relationlet pinAllVars() {
        Set<Var> vars = this.getVarsMentioned();
        Relationlet result = this.pinAllVars(vars);
        return result;
    }

    default public Relationlet pinAllVars(Iterable<Var> vars) {
        for (Var var : vars) {
            this.setPinnedVar(var, true);
        }
        return this;
    }

    public Set<Var> getPinnedVars();

    public Relationlet setPinnedVar(Var var1, boolean var2);

    public RelationletSimple materialize();

    public NestedVarMap getNestedVarMap();

    default public Var resolve(VarRefStatic varRef) {
        List<String> labels = varRef.getLabels();
        Var v = varRef.getV();
        NestedVarMap src = this.getNestedVarMap();
        NestedVarMap tgt = src.get(labels);
        Map<Var, Var> map = tgt.getLocalToFinalVarMap();
        Var result = map.get(v);
        return result;
    }
}

