/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.facete.v3.bgp.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.aksw.facete.v3.api.Direction;
import org.aksw.facete.v3.api.traversal.TraversalNode;
import org.aksw.facete.v3.bgp.api.BgpDirNode;
import org.aksw.facete.v3.bgp.api.BgpMultiNode;
import org.aksw.jenax.arq.util.syntax.ElementUtils;
import org.aksw.jenax.arq.util.var.Vars;
import org.aksw.jenax.sparql.fragment.api.Fragment2;
import org.aksw.jenax.sparql.fragment.impl.Fragment2Impl;
import org.aksw.jenax.sparql.path.PathUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.path.P_Link;
import org.apache.jena.sparql.path.P_Path0;
import org.apache.jena.sparql.path.P_ReverseLink;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementGroup;

public interface BgpNode
extends TraversalNode<BgpNode, BgpDirNode, BgpMultiNode>,
Resource {
    @Override
    public BgpDirNode fwd();

    @Override
    public BgpDirNode bwd();

    public Map<Resource, BgpMultiNode> fwdMultiNodes();

    public Map<Resource, BgpMultiNode> bwdMultiNodes();

    public BgpNode chRoot();

    public static P_Path0 toStep(BgpMultiNode node) {
        P_Link result = Direction.FORWARD.equals((Object)node.getDirection()) ? new P_Link(node.reachingProperty().asNode()) : new P_ReverseLink(node.reachingProperty().asNode());
        return result;
    }

    public static P_Path0 toStep(BgpNode node) {
        return Optional.ofNullable(node.parent()).map(BgpNode::toStep).orElse(null);
    }

    public static Path toSparqlPath(BgpNode node) {
        List<P_Path0> steps = BgpNode.toSparqlSteps(node);
        Path result = PathUtils.toSparqlPath(steps);
        return result;
    }

    public static List<P_Path0> toSparqlSteps(BgpNode node) {
        P_Path0 tmp;
        ArrayList<P_Path0> result = new ArrayList<P_Path0>();
        while (node != null && (tmp = BgpNode.toStep(node)) != null) {
            result.add(tmp);
            node = node.parent().parent();
        }
        Collections.reverse(result);
        return result;
    }

    public BgpNode as(String var1);

    public BgpNode as(Var var1);

    public String alias();

    public BgpMultiNode parent();

    public BgpNode root();

    public static Fragment2 getReachingRelation(BgpNode state) {
        Fragment2Impl result;
        BgpMultiNode parent = state.parent();
        if (parent == null) {
            result = new Fragment2Impl((Element)new ElementGroup(), Vars.s, Vars.o);
        } else {
            Property p = parent.reachingProperty();
            Direction dir = parent.getDirection();
            result = BgpNode.create(p.asNode(), dir);
        }
        return result;
    }

    public static Fragment2 create(Node node, Direction dir) {
        Triple t = Direction.BACKWARD.equals((Object)dir) ? Triple.create((Node)Vars.o, (Node)node, (Node)Vars.s) : Triple.create((Node)Vars.s, (Node)node, (Node)Vars.o);
        Fragment2Impl result = new Fragment2Impl((Element)ElementUtils.createElement((Triple)t), Vars.s, Vars.o);
        return result;
    }
}

