/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.data_query.api;

import com.google.common.collect.Iterables;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.aksw.commons.util.range.CountInfo;
import org.aksw.jena_sparql_api.data_query.api.DataNode;
import org.aksw.jena_sparql_api.data_query.api.DataQueryVarView;
import org.aksw.jena_sparql_api.data_query.api.NodePath;
import org.aksw.jena_sparql_api.data_query.api.QuerySpec;
import org.aksw.jena_sparql_api.data_query.api.ResolverNode;
import org.aksw.jena_sparql_api.pathlet.Path;
import org.aksw.jenax.arq.util.expr.ExprListUtils;
import org.aksw.jenax.arq.util.var.Vars;
import org.aksw.jenax.dataaccess.sparql.datasource.RDFDataSource;
import org.aksw.jenax.dataaccess.sparql.factory.datasource.RDFDataSources;
import org.aksw.jenax.sparql.fragment.api.Fragment;
import org.aksw.jenax.sparql.fragment.api.Fragment1;
import org.aksw.jenax.sparql.fragment.impl.Concept;
import org.aksw.jenax.sparql.fragment.impl.FragmentImpl;
import org.apache.jena.graph.FrontsNode;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdfconnection.SparqlQueryConnection;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.E_NotOneOf;
import org.apache.jena.sparql.expr.E_OneOf;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.ExprVars;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementFilter;
import org.apache.jena.sparql.util.ExprUtils;
import org.apache.jena.sparql.util.NodeUtils;

public interface DataQuery<T extends RDFNode> {
    public DataQuery<T> pseudoRandom(Random var1);

    public DataQuery<T> peek(Consumer<? super DataQuery<T>> var1);

    public NodePath get(String var1);

    public DataQueryVarView<T> getAttr(String var1);

    public Single<Model> execConstruct();

    public Fragment1 fetchPredicates();

    public DataNode getRoot();

    public DataQuery<T> add(Property var1);

    public DataQuery<T> addOptional(Property var1);

    public DataQuery<T> filterUsing(Fragment var1, String ... var2);

    public DataQuery<T> filter(Fragment1 var1);

    default public DataQuery<T> filter(String exprStr) {
        Expr expr = ExprUtils.parse((String)exprStr);
        return this.filter(expr);
    }

    public static Fragment1 toUnaryFiler(Expr expr) {
        Set vars = ExprVars.getVarsMentioned((Expr)expr);
        if (vars.size() != 1) {
            throw new IllegalArgumentException("Provided expression must contain exactly 1 variable");
        }
        Var var = (Var)Iterables.getFirst((Iterable)vars, null);
        Concept result = new Concept((Element)new ElementFilter(expr), var);
        return result;
    }

    public DataQuery<T> filter(Expr var1);

    public DataQuery<T> filterDirect(Element var1);

    public DataQuery<T> dataSource(RDFDataSource var1);

    public RDFDataSource dataSource();

    @Deprecated
    default public SparqlQueryConnection connection() {
        RDFDataSource dataSource = this.dataSource();
        SparqlQueryConnection result = Optional.ofNullable(dataSource).map(RDFDataSource::getConnection).orElse(null);
        return result;
    }

    @Deprecated
    default public DataQuery<T> connection(SparqlQueryConnection connection) {
        return this.dataSource(RDFDataSources.ofQueryConnection((SparqlQueryConnection)connection));
    }

    default public DataQuery<T> only(Iterable<Node> nodes) {
        E_OneOf e = new E_OneOf((Expr)new ExprVar(Vars.s), ExprListUtils.nodesToExprs(nodes));
        return this.filter((Fragment1)new Concept((Element)new ElementFilter((Expr)e), Vars.s));
    }

    default public DataQuery<T> only(Node ... nodes) {
        return this.only(Arrays.asList(nodes));
    }

    default public DataQuery<T> only(RDFNode ... rdfNodes) {
        return this.only(Arrays.asList(rdfNodes).stream().map(FrontsNode::asNode).collect(Collectors.toList()));
    }

    default public DataQuery<T> only(String ... iris) {
        return this.only(NodeUtils.convertToListNodes(Arrays.asList(iris)));
    }

    default public DataQuery<T> exclude(Iterable<Node> nodes) {
        E_NotOneOf e = new E_NotOneOf((Expr)new ExprVar(Vars.s), ExprListUtils.nodesToExprs(nodes));
        return this.filter((Fragment1)new Concept((Element)new ElementFilter((Expr)e), Vars.s));
    }

    default public DataQuery<T> exclude(Node ... nodes) {
        return this.exclude(Arrays.asList(nodes));
    }

    default public DataQuery<T> exclude(RDFNode ... rdfNodes) {
        return this.exclude(Arrays.asList(rdfNodes).stream().map(FrontsNode::asNode).collect(Collectors.toList()));
    }

    default public DataQuery<T> exclude(String ... iris) {
        return this.exclude(NodeUtils.convertToListNodes(Arrays.asList(iris)));
    }

    public DataQuery<T> limit(Long var1);

    default public DataQuery<T> limit(Integer limit) {
        return this.limit(limit == null ? null : Long.valueOf(limit.longValue()));
    }

    public DataQuery<T> offset(Long var1);

    default public DataQuery<T> offset(Integer offset) {
        return this.offset(offset == null ? null : Long.valueOf(offset.longValue()));
    }

    public DataQuery<T> sample(boolean var1);

    default public DataQuery<T> sample() {
        return this.sample(true);
    }

    public boolean isSampled();

    public DataQuery<T> ordered(boolean var1);

    default public DataQuery<T> ordered() {
        return this.ordered(true);
    }

    public boolean isOrdered();

    public DataQuery<T> randomOrder(boolean var1);

    default public DataQuery<T> randomOrder() {
        return this.randomOrder(true);
    }

    public boolean isRandomOrder();

    public QuerySpec toConstructQueryNew();

    public Var getDefaultVar();

    public Node getSuperRootNode();

    @Deprecated
    default public Map.Entry<Node, Query> toConstructQuery() {
        QuerySpec qs = this.toConstructQueryNew();
        return new AbstractMap.SimpleEntry<Var, Query>(this.getDefaultVar(), qs.getQuery());
    }

    default public Fragment baseRelation() {
        return new FragmentImpl(this.baseElement(), this.primaryKeyVars());
    }

    public List<Var> primaryKeyVars();

    public Element baseElement();

    public Flowable<T> exec();

    public Single<CountInfo> count();

    public Single<CountInfo> count(Long var1, Long var2);

    public ResolverNode resolver();

    public DataQuery<T> addOrderBy(Node var1, int var2);

    default public DataQuery<T> addOrderBy(Path path, int direction) {
        Node node = this.nodeForPath(path);
        return this.addOrderBy(node, direction);
    }

    public Node nodeForPath(Path var1);

    public <U extends RDFNode> DataQuery<U> as(Class<U> var1);
}

