/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.facete.v3.api;

import java.util.Objects;
import java.util.Set;
import org.aksw.facete.v3.api.FacetConstraintControl;
import org.aksw.facete.v3.api.FacetConstraints;
import org.aksw.facete.v3.api.TreeQueryNode;
import org.apache.jena.sparql.expr.Expr;

public class FacetConstraintControlImpl
implements FacetConstraintControl {
    protected FacetConstraints container;
    protected Set<TreeQueryNode> references;
    protected Expr expr;

    public FacetConstraintControlImpl(FacetConstraints container, Set<TreeQueryNode> references, Expr expr) {
        this.container = container;
        this.references = references;
        this.expr = expr;
    }

    @Override
    public boolean enabled() {
        return Boolean.TRUE.equals(this.container.model.get(this.references, (Object)this.expr));
    }

    @Override
    public void unlink() {
        this.container.model.remove(this.references, (Object)this.expr);
    }

    public boolean isUnlinked() {
        return !this.container.model.contains(this.references, (Object)this.expr);
    }

    @Override
    public FacetConstraintControl enabled(boolean onOrOff) {
        this.container.model.put(this.references, (Object)this.expr, (Object)onOrOff);
        return this;
    }

    @Override
    public Expr expr() {
        return this.expr;
    }

    public int hashCode() {
        return Objects.hash(this.container, this.expr, this.references);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FacetConstraintControlImpl other = (FacetConstraintControlImpl)obj;
        return Objects.equals(this.container, other.container) && Objects.equals(this.expr, other.expr) && Objects.equals(this.references, other.references);
    }
}

