/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.data_query.util;

import java.util.Arrays;
import org.aksw.jenax.arq.util.syntax.ElementUtils;
import org.aksw.jenax.sparql.fragment.api.Fragment2;
import org.aksw.jenax.sparql.fragment.impl.Concept;
import org.aksw.jenax.sparql.fragment.impl.Fragment2Impl;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.E_Bound;
import org.apache.jena.sparql.expr.E_Exists;
import org.apache.jena.sparql.expr.E_Function;
import org.apache.jena.sparql.expr.E_LogicalOr;
import org.apache.jena.sparql.expr.E_Regex;
import org.apache.jena.sparql.expr.E_Str;
import org.apache.jena.sparql.expr.E_StrContains;
import org.apache.jena.sparql.expr.E_StrLowerCase;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementFilter;
import org.apache.jena.sparql.syntax.ElementOptional;
import org.apache.jena.vocabulary.RDFS;

public class KeywordSearchUtils {
    public static Concept createConceptRegex(Fragment2 relation, String searchString, boolean includeSubject) {
        Concept result = includeSubject ? KeywordSearchUtils.createConceptRegexIncludeSubject(relation, searchString) : KeywordSearchUtils.createConceptRegexLabelOnly(relation, searchString);
        return result;
    }

    public static Concept createConceptRegexLabelOnly(Fragment2 relation, String searchString) {
        Concept result;
        if (searchString != null) {
            Element element = ElementUtils.groupIfNeeded(Arrays.asList(relation.getElement(), new ElementFilter((Expr)new E_Regex((Expr)new E_Str((Expr)new ExprVar(relation.getTargetVar())), (Expr)NodeValue.makeString((String)searchString), (Expr)NodeValue.makeString((String)"i")))));
            result = new Concept(element, relation.getSourceVar());
        } else {
            result = null;
        }
        return result;
    }

    public static Concept createConceptRegexIncludeSubject(Fragment2 relation, String searchString) {
        Concept result;
        if (searchString != null) {
            Element relEl = relation.getElement();
            Var s = relation.getSourceVar();
            Var o = relation.getTargetVar();
            ExprVar es = new ExprVar(s);
            ExprVar eo = new ExprVar(o);
            NodeValue ess = NodeValue.makeString((String)searchString);
            NodeValue flags = NodeValue.makeString((String)"i");
            E_Regex innerExpr = new E_Regex((Expr)new E_Str((Expr)eo), (Expr)ess, (Expr)flags);
            E_LogicalOr outerExpr = new E_LogicalOr((Expr)new E_Regex((Expr)new E_Str((Expr)es), (Expr)ess, (Expr)flags), (Expr)new E_Bound((Expr)eo));
            Element element = ElementUtils.groupIfNeeded(Arrays.asList(new ElementOptional(ElementUtils.groupIfNeeded(Arrays.asList(relEl, new ElementFilter((Expr)innerExpr)))), new ElementFilter((Expr)outerExpr)));
            result = new Concept(element, s);
        } else {
            result = null;
        }
        return result;
    }

    public static Concept createConceptExistsRegexIncludeSubject(Fragment2 relation, String searchString) {
        Concept result;
        if (searchString != null) {
            Element relEl = relation.getElement();
            Var s = relation.getSourceVar();
            Var o = relation.getTargetVar();
            ExprVar es = new ExprVar(s);
            ExprVar eo = new ExprVar(o);
            NodeValue ess = NodeValue.makeString((String)searchString);
            NodeValue flags = NodeValue.makeString((String)"i");
            E_Regex innerExpr = new E_Regex((Expr)new E_Str((Expr)eo), (Expr)ess, (Expr)flags);
            ElementFilter element = new ElementFilter((Expr)new E_LogicalOr((Expr)new E_Regex((Expr)new E_Str((Expr)es), (Expr)ess, (Expr)flags), (Expr)new E_Exists(ElementUtils.groupIfNeeded(Arrays.asList(relEl, new ElementFilter((Expr)innerExpr))))));
            result = new Concept((Element)element, s);
        } else {
            result = null;
        }
        return result;
    }

    public static Concept createConceptBifContains(Fragment2 relation, String searchString) {
        Concept result;
        if (searchString != null) {
            Var o = relation.getTargetVar();
            ExprVar eo = new ExprVar(o);
            NodeValue nv = NodeValue.makeString((String)searchString);
            Element element = ElementUtils.groupIfNeeded(Arrays.asList(relation.getElement(), new ElementFilter((Expr)new E_Function("bif:contains", new ExprList(Arrays.asList(eo, nv))))));
            Var s = relation.getSourceVar();
            result = new Concept(element, s);
        } else {
            result = null;
        }
        return result;
    }

    public static Concept createConceptExistsRegex(Fragment2 relation, String searchString, boolean includeSubject) {
        Concept result = includeSubject ? KeywordSearchUtils.createConceptExistsRegexIncludeSubject(relation, searchString) : KeywordSearchUtils.createConceptExistsRegexLabelOnly(relation, searchString);
        return result;
    }

    public static Concept createConceptExistsRegexLabelOnly(Fragment2 relation, String searchString) {
        Concept result;
        if (searchString != null) {
            ElementFilter element = new ElementFilter((Expr)new E_Exists(ElementUtils.groupIfNeeded((Element[])new Element[]{relation.getElement(), new ElementFilter((Expr)new E_Regex((Expr)new E_Str((Expr)new ExprVar(relation.getTargetVar())), (Expr)NodeValue.makeString((String)searchString), (Expr)NodeValue.makeString((String)"i")))})));
            result = new Concept((Element)element, relation.getSourceVar());
        } else {
            result = null;
        }
        return result;
    }

    public static Concept createConceptExistsStrConstainsLabelOnly(Fragment2 relation, String searchString) {
        Concept result;
        String str = searchString.toLowerCase();
        if (searchString != null) {
            ElementFilter element = new ElementFilter((Expr)new E_Exists(ElementUtils.groupIfNeeded((Element[])new Element[]{relation.getElement(), new ElementFilter((Expr)new E_StrContains((Expr)new E_StrLowerCase((Expr)new E_Str((Expr)new ExprVar(relation.getTargetVar()))), (Expr)NodeValue.makeString((String)str)))})));
            result = new Concept((Element)element, relation.getSourceVar());
        } else {
            result = null;
        }
        return result;
    }

    public static void main(String[] args) {
        System.out.println(KeywordSearchUtils.createConceptExistsRegexIncludeSubject(Fragment2Impl.create((Node)RDFS.Nodes.label), "test"));
        System.out.println(KeywordSearchUtils.createConceptExistsRegexLabelOnly(Fragment2Impl.create((Node)RDFS.Nodes.label), "test"));
    }
}

