/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.pathlet;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.aksw.facete.v3.api.path.Resolver;
import org.aksw.facete.v3.api.path.StepImpl;
import org.aksw.jena_sparql_api.pathlet.Path;
import org.aksw.jena_sparql_api.pathlet.Pathlet;
import org.aksw.jena_sparql_api.pathlet.PathletContainer;
import org.aksw.jena_sparql_api.pathlet.PathletSimple;
import org.aksw.jena_sparql_api.relationlet.Relationlet;
import org.aksw.jena_sparql_api.relationlet.RelationletBinary;
import org.aksw.jena_sparql_api.relationlet.RelationletEntry;
import org.aksw.jena_sparql_api.relationlet.RelationletJoinerImpl;
import org.aksw.jena_sparql_api.relationlet.VarRefEntry;
import org.aksw.jena_sparql_api.relationlet.VarRefStatic;
import org.aksw.jenax.arq.util.var.Vars;
import org.aksw.jenax.sparql.fragment.api.Fragment2;
import org.aksw.jenax.sparql.fragment.impl.Fragment2Impl;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.path.P_Path0;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.ElementOptional;

public class PathletJoinerImpl
extends RelationletJoinerImpl<Pathlet>
implements PathletContainer {
    public static final Var srcJoinVar = Var.alloc((String)"srcJoinVar");
    public static final Var tgtJoinVar = Var.alloc((String)"tgtJoinVar");
    public static final Pathlet emptyPathlet = PathletJoinerImpl.newPathlet(Fragment2Impl.empty((Var)Vars.s));
    protected Table<Object, String, RelationletEntry<? extends Pathlet>> keyToAliasToMember = HashBasedTable.create();
    protected Function<Element, Element> elementPostProcessor;
    protected Resolver resolver;

    public static Pathlet newPathlet(Fragment2 br) {
        return new PathletSimple(br.getSourceVar(), br.getTargetVar(), new RelationletBinary(br));
    }

    public PathletJoinerImpl(Resolver resolver) {
        this(resolver, emptyPathlet, RelationletJoinerImpl::flatten);
    }

    public PathletJoinerImpl() {
        this(null, emptyPathlet, RelationletJoinerImpl::flatten);
    }

    public PathletJoinerImpl(Resolver resolver, Pathlet rootPathlet, Function<? super ElementGroup, ? extends Element> postProcessor) {
        super(postProcessor);
        super.add("root", rootPathlet);
        this.resolver = resolver;
        this.expose(srcJoinVar.getName(), "root", rootPathlet.getSrcVar().getName());
        this.expose(tgtJoinVar.getName(), "root", rootPathlet.getTgtVar().getName());
    }

    public RelationletEntry<? extends Pathlet> getRootMember() {
        RelationletEntry result = this.getMemberByLabel("root");
        return result;
    }

    public Supplier<VarRefStatic> resolveStep(StepImpl step) {
        Path path = Path.newPath().appendStep(step);
        Supplier<VarRefStatic> result = this.resolvePath(path);
        return result;
    }

    public Supplier<VarRefStatic> resolvePath(Path path) {
        this.resolvePath(path, true);
        Supplier<VarRefStatic> result = () -> this.pathToVarRef(path);
        return result;
    }

    VarRefStatic pathToVarRef(Path path) {
        List<RelationletEntry<PathletJoinerImpl>> list = this.resolvePath(path, false);
        List<String> labels = list.stream().map(RelationletEntry::getId).collect(Collectors.toList());
        Var v = list.isEmpty() ? this.getTgtVar() : ((PathletJoinerImpl)((RelationletEntry)Iterables.getLast(list)).getRelationlet()).getTgtVar();
        VarRefStatic result = new VarRefStatic(labels, v);
        return result;
    }

    List<RelationletEntry<PathletJoinerImpl>> resolvePath(Path path, boolean createIfNotExists) {
        List<StepImpl> steps = Path.getSteps(path);
        List<RelationletEntry<PathletJoinerImpl>> result = this.resolve(steps.iterator(), createIfNotExists);
        return result;
    }

    RelationletEntry<PathletJoinerImpl> resolveStep(StepImpl step, boolean createIfNotExists) {
        String type = step.getType();
        String alias = step.getAlias();
        Object key = step.getKey();
        return switch (type) {
            case "optional" -> this.optional(alias, createIfNotExists);
            case "br" -> this.step(key, alias, createIfNotExists);
            default -> throw new RuntimeException("Unknown step type " + type);
        };
    }

    List<RelationletEntry<PathletJoinerImpl>> resolve(Iterator<StepImpl> it, boolean createIfNotExists) {
        ArrayList<RelationletEntry<PathletJoinerImpl>> result = new ArrayList<RelationletEntry<PathletJoinerImpl>>();
        PathletJoinerImpl state = this;
        while (it.hasNext() && state != null) {
            StepImpl step = it.next();
            RelationletEntry<PathletJoinerImpl> tmp = state.resolveStep(step, createIfNotExists);
            state = tmp.getRelationlet();
            if (createIfNotExists) {
                Objects.requireNonNull(state, "Step resolution unexpectedly returned null");
            }
            result.add(tmp);
        }
        return result;
    }

    Pathlet add(Object key, String alias, Pathlet pathlet) {
        return null;
    }

    public RelationletEntry<PathletJoinerImpl> step(Object key, String alias, boolean createIfNotExists) {
        Fragment2 br;
        P_Path0 p = key instanceof P_Path0 ? (P_Path0)key : null;
        Set<Var> pinnedVars = Collections.emptySet();
        Resolver subResolver = null;
        if (p == null) {
            br = (Fragment2)key;
            subResolver = null;
        } else if (this.resolver != null) {
            subResolver = this.resolver.resolve(p, alias);
            Collection<RelationletBinary> brs = subResolver.getReachingRelationlet();
            RelationletBinary rb = brs.iterator().next();
            br = rb.getBinaryRelation();
            pinnedVars = rb.getPinnedVars();
        } else {
            Node n = p.getNode();
            boolean isFwd = p.isForward();
            br = Fragment2Impl.create((Var)Vars.s, (Node)n, (Var)Vars.o, (boolean)isFwd);
        }
        RelationletEntry<PathletJoinerImpl> result = this.step(createIfNotExists, subResolver, key, br, pinnedVars, alias, RelationletJoinerImpl::flatten);
        return result;
    }

    @Override
    public RelationletEntry<Pathlet> add(String label, Pathlet item) {
        RelationletEntry<Pathlet> result = super.add(label, item);
        RelationletEntry<? extends Pathlet> root = this.getRootMember();
        VarRefEntry rootVarRef = root.createVarRef(x -> x.getTgtVar());
        VarRefEntry memberVarRef = result.createVarRef(x -> x.getSrcVar());
        this.addJoin(rootVarRef, memberVarRef);
        return result;
    }

    public RelationletEntry<PathletJoinerImpl> step(boolean createIfNotExists, Resolver subResolver, Object key, Fragment2 br, Collection<Var> pinnedVars, String alias, Function<? super ElementGroup, ? extends Element> fn) {
        RelationletEntry<PathletJoinerImpl> result = (RelationletEntry<PathletJoinerImpl>)this.keyToAliasToMember.get(key = key == null ? String.valueOf(br) : key, (Object)(alias = alias == null ? "default" : alias));
        if (result == null && createIfNotExists) {
            Pathlet childRootPathlet = PathletJoinerImpl.newPathlet(br);
            childRootPathlet.pinAllVars(pinnedVars);
            PathletJoinerImpl subContainer = new PathletJoinerImpl(subResolver, childRootPathlet, fn);
            result = this.add(subContainer);
            this.keyToAliasToMember.put(key, (Object)alias, result);
        }
        return result;
    }

    public RelationletEntry<PathletJoinerImpl> optional(String label, boolean isLookup) {
        RelationletEntry<PathletJoinerImpl> result = this.step(isLookup, this.resolver, "optional", Fragment2Impl.empty(), Collections.emptySet(), "default", x -> new ElementOptional(RelationletJoinerImpl.flatten((Element)x)));
        return result;
    }

    @Override
    public Collection<Var> getExposedVars() {
        return null;
    }

    @Override
    public Set<Var> getPinnedVars() {
        return null;
    }

    @Override
    public Relationlet setPinnedVar(Var var, boolean onOrOff) {
        return null;
    }

    @Override
    public Var getSrcVar() {
        return srcJoinVar;
    }

    @Override
    public Var getTgtVar() {
        return tgtJoinVar;
    }

    public String toString() {
        return "PathletContainer [keyToAliasToMember=" + String.valueOf(this.keyToAliasToMember) + "]";
    }
}

