/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.facete.v3.api;

import com.google.common.collect.MapMaker;
import java.util.Map;
import org.aksw.facete.v3.api.TreeQueryImpl;
import org.aksw.facete.v3.api.TreeQueryNode;
import org.aksw.jenax.path.core.FacetPath;
import org.aksw.jenax.path.core.FacetPathOps;
import org.aksw.jenax.path.core.FacetStep;

public class TreeQueryNodeImpl
implements TreeQueryNode {
    protected TreeQueryImpl treeModel;
    protected TreeQueryNodeImpl parent;
    protected Map<FacetStep, TreeQueryNode> stepToChild = new MapMaker().weakValues().makeMap();

    public TreeQueryNodeImpl(TreeQueryImpl treeModel, TreeQueryNodeImpl parent) {
        this.treeModel = treeModel;
        this.parent = parent;
    }

    @Override
    public TreeQueryNode getOrCreateChild(FacetStep step) {
        TreeQueryNode result = this.stepToChild.computeIfAbsent(step, s -> new TreeQueryNodeImpl(this.treeModel, this));
        return result;
    }

    @Override
    public void chRoot() {
        if (this.parent != null) {
            this.parent.chRoot();
        }
        if (this.parent != null) {
            FacetStep reachingStep = this.reachingStep();
            String alias = reachingStep.getAlias();
            Object adjustedAlias = alias == null ? "parent" : (alias.startsWith("parent.") ? alias.substring("parent.".length()) : (alias.equals("parent") ? null : "parent." + alias));
            FacetStep invertedStep = new FacetStep(reachingStep.getNode(), !reachingStep.isForward(), (String)adjustedAlias, reachingStep.getTargetComponent());
            this.parent.parent = this;
            this.parent.stepToChild.remove(reachingStep);
            this.stepToChild.put(invertedStep, this.parent);
            this.parent = null;
            this.treeModel.root = this;
        }
    }

    @Override
    public TreeQueryImpl getTree() {
        return this.treeModel;
    }

    @Override
    public TreeQueryNode getParent() {
        return this.parent;
    }

    public FacetStep getStepToChild(TreeQueryNode child) {
        FacetStep result = this.stepToChild.entrySet().stream().filter(e -> e.getValue() == child).map(Map.Entry::getKey).findFirst().orElse(null);
        return result;
    }

    @Override
    public FacetStep reachingStep() {
        if (this.parent == null) {
            throw new RuntimeException("Method must not be called on a root node");
        }
        FacetStep result = this.parent.getStepToChild(this);
        return result;
    }

    public FacetPath getFacetPath() {
        TreeQueryNode p = this.getParent();
        FacetPath result = p == null ? FacetPath.newAbsolutePath((FacetStep[])new FacetStep[0]) : (FacetPath)this.parent.getFacetPath().resolve((Object)this.reachingStep());
        return result;
    }

    public String toString() {
        return this.stepToChild.toString();
    }

    @Override
    public TreeQueryNode resolve(FacetPath facetPath) {
        TreeQueryNode tmp = facetPath.isAbsolute() ? this.treeModel.root() : this;
        for (FacetStep step : facetPath.getSegments()) {
            if (FacetPathOps.PARENT.equals((Object)step)) {
                tmp = tmp.getParent();
                continue;
            }
            if (FacetPathOps.SELF.equals((Object)step)) continue;
            tmp = tmp.getOrCreateChild(step);
        }
        return tmp;
    }
}

