/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.relationlet;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aksw.commons.collections.cluster.IndirectEquiMap;
import org.aksw.commons.collections.collectors.CollectorUtils;
import org.aksw.commons.collections.generator.Generator;
import org.aksw.commons.collections.generator.GeneratorBlacklist;
import org.aksw.commons.collections.generator.GeneratorLendingImpl;
import org.aksw.commons.collections.stacks.NestedStack;
import org.aksw.facete.v3.api.path.Join;
import org.aksw.facete.v3.api.path.NestedVarMap;
import org.aksw.facete.v3.api.path.NestedVarMapImpl;
import org.aksw.jena_sparql_api.relationlet.Relationlet;
import org.aksw.jena_sparql_api.relationlet.RelationletBaseWithMutableFixedVars;
import org.aksw.jena_sparql_api.relationlet.RelationletEntry;
import org.aksw.jena_sparql_api.relationlet.RelationletNestedImpl;
import org.aksw.jena_sparql_api.relationlet.RelationletSimple;
import org.aksw.jena_sparql_api.relationlet.VarRef;
import org.aksw.jena_sparql_api.relationlet.VarRefEntry;
import org.aksw.jena_sparql_api.relationlet.VarRefStatic;
import org.aksw.jenax.arq.util.syntax.ElementUtils;
import org.aksw.jenax.arq.util.var.VarGeneratorImpl2;
import org.aksw.jenax.sparql.fragment.api.Fragment;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.syntaxtransform.NodeTransformSubst;

public class RelationletJoinerImpl<T extends Relationlet>
extends RelationletBaseWithMutableFixedVars {
    protected Map<String, RelationletEntry<? extends T>> labelToRe = new LinkedHashMap<String, RelationletEntry<? extends T>>();
    protected Function<? super ElementGroup, ? extends Element> postProcessor;
    Map<Var, VarRefStatic> explicitExposedVars = new LinkedHashMap<Var, VarRefStatic>();
    Generator<String> gen = GeneratorLendingImpl.createPrefixedInt((String)"x", (int)0);
    protected List<Expr> exprs;
    List<Join> joins = new ArrayList<Join>();

    public static Stream<Element> flatten(Stream<Element> stream) {
        Stream<Element> result = stream.flatMap(e -> e instanceof ElementGroup ? RelationletJoinerImpl.flatten(((ElementGroup)e).getElements().stream()) : Stream.of(e));
        return result;
    }

    public static Element flatten(Element e) {
        List tmp = RelationletJoinerImpl.flatten(Stream.of(e)).collect(Collectors.toList());
        Element result = ElementUtils.groupIfNeeded(tmp);
        return result;
    }

    public RelationletJoinerImpl() {
        this(RelationletJoinerImpl::flatten);
    }

    public RelationletJoinerImpl(Function<? super ElementGroup, ? extends Element> postProcessor) {
        this.postProcessor = postProcessor;
    }

    public Function<? super ElementGroup, ? extends Element> getPostProcessor() {
        return this.postProcessor;
    }

    public void setMaterializeElementPostProcessor(Function<? super ElementGroup, ? extends Element> postProcessor) {
        this.postProcessor = postProcessor;
    }

    public String getLabelForRelationlet(Object obj) {
        String result = this.labelToRe.entrySet().stream().filter(e -> e.getValue() == obj).map(Map.Entry::getKey).findFirst().orElse(null);
        return result;
    }

    public void expose(String exposedName, String alias, String varName) {
        Var exposedVar = Var.alloc((String)exposedName);
        VarRefStatic varRef = new VarRefStatic(alias, Var.alloc((String)varName));
        this.explicitExposedVars.put(exposedVar, varRef);
    }

    public <U extends T> RelationletEntry<U> add(U item) {
        String label = "genid" + (String)this.gen.next();
        RelationletEntry<U> result = this.add(label, item);
        return result;
    }

    public <U extends T> RelationletEntry<U> add(String label, U item) {
        RelationletEntry<U> entry = new RelationletEntry<U>(label, item);
        this.labelToRe.put(label, entry);
        return entry;
    }

    public void getConflictingVars() {
    }

    public void getNonConflictingVars() {
    }

    public List<String> find(RelationletEntry<?> entry) {
        NestedStack<String> stack = RelationletJoinerImpl.find(entry, new RelationletEntry<RelationletJoinerImpl>(null, this), null);
        List result = stack.asList();
        return result;
    }

    public static NestedStack<String> find(RelationletEntry<?> entry, RelationletEntry<?> current, NestedStack<String> stack) {
        NestedStack<String> result;
        block2: {
            String id;
            NestedStack next;
            RelationletEntry e;
            block1: {
                result = null;
                if (entry != current) break block1;
                result = stack;
                break block2;
            }
            Object r = current.getRelationlet();
            if (!(r instanceof RelationletJoinerImpl)) break block2;
            RelationletJoinerImpl tmp = (RelationletJoinerImpl)r;
            Iterator iterator = tmp.labelToRe.values().iterator();
            while (iterator.hasNext() && (result = RelationletJoinerImpl.find(entry, e = iterator.next(), (NestedStack<String>)(next = new NestedStack(stack, (Object)(id = e.getId()))))) == null) {
            }
        }
        return result;
    }

    public VarRefStatic matVarRef(Object varRef) {
        VarRefStatic result;
        if (varRef instanceof VarRefStatic) {
            result = (VarRefStatic)varRef;
        } else if (varRef instanceof VarRefEntry) {
            VarRefEntry vre = (VarRefEntry)varRef;
            RelationletEntry<?> e = vre.getEntry();
            List<String> aliases = this.find(e);
            result = new VarRefStatic(aliases, vre.getVar());
        } else {
            throw new IllegalArgumentException("Unknown var ref type " + String.valueOf(varRef));
        }
        return result;
    }

    public static List<VarRef> toVarRefs(String alias, List<Var> vars) {
        List<VarRef> result = vars.stream().map(v -> new VarRefStatic(alias, (Var)v)).collect(Collectors.toList());
        return result;
    }

    public void addJoin(VarRef lhsVarRef, VarRef rhsVarRef) {
        Join join = new Join(Collections.singletonList(lhsVarRef), Collections.singletonList(rhsVarRef));
        this.joins.add(join);
    }

    public void addJoin(String lhsAlias, List<Var> lhsVars, String rhsAlias, List<Var> rhsVars) {
        List<VarRef> lhs = RelationletJoinerImpl.toVarRefs(lhsAlias, lhsVars);
        List<VarRef> rhs = RelationletJoinerImpl.toVarRefs(rhsAlias, rhsVars);
        Join join = new Join(lhs, rhs);
        this.joins.add(join);
    }

    public Fragment effective() {
        return null;
    }

    public RelationletEntry<? extends T> getMemberByLabel(String label) {
        return this.labelToRe.get(label);
    }

    public static VarRefStatic resolveMat(Map<String, RelationletSimple> map, VarRefStatic varRef) {
        Map.Entry<String, Var> e = RelationletJoinerImpl.resolveMatCore(map, varRef);
        VarRefStatic result = new VarRefStatic(e.getKey(), e.getValue());
        return result;
    }

    public static Map.Entry<String, Var> resolveMatCore(Map<String, RelationletSimple> map, VarRefStatic varRef) {
        Var v = Objects.requireNonNull(varRef.getV());
        List<String> labels = varRef.getLabels();
        if (labels.isEmpty()) {
            throw new RuntimeException("Should not happen");
        }
        String label = labels.get(0);
        List<String> subLabels = labels.subList(1, labels.size());
        Relationlet r = map.get(label);
        NestedVarMap subMap = r.getNestedVarMap();
        NestedVarMap tmp = subLabels.isEmpty() ? subMap : subMap.get(subLabels);
        Map<Var, Var> varMap = tmp.getLocalToFinalVarMap();
        Var resultVar = varMap.get(v);
        Objects.requireNonNull(resultVar);
        Map.Entry result = Maps.immutableEntry((Object)label, (Object)resultVar);
        return result;
    }

    @Override
    public RelationletSimple materialize() {
        Var finalVar;
        Map materializedMembers = (Map)this.labelToRe.values().stream().collect(CollectorUtils.toLinkedHashMap(RelationletEntry::getId, e -> e.getRelationlet().materialize()));
        Predicate<Var> baseBlacklist = x -> false;
        IndirectEquiMap aliasedVarToEffectiveVar = new IndirectEquiMap();
        for (Join join : this.joins) {
            List<VarRef> lhsRefs = join.getLhs();
            List<VarRef> list = join.getRhs();
            int n = join.getLhs().size();
            for (int i = 0; i < n; ++i) {
                VarRef lhsRef = (VarRef)lhsRefs.get(i);
                VarRef rhsRef = list.get(i);
                VarRefStatic rawLhsEntry = this.matVarRef(lhsRef);
                VarRefStatic rawRhsEntry = this.matVarRef(rhsRef);
                Iterator lhsEntry = RelationletJoinerImpl.resolveMatCore(materializedMembers, rawLhsEntry);
                Map.Entry<String, Var> entry = RelationletJoinerImpl.resolveMatCore(materializedMembers, rawRhsEntry);
                aliasedVarToEffectiveVar.stateEqual(entry, lhsEntry);
            }
        }
        Map clusters = aliasedVarToEffectiveVar.getEquivalences().asMap();
        HashMultimap varToRids = HashMultimap.create();
        for (Map.Entry entry : materializedMembers.entrySet()) {
            String id = (String)entry.getKey();
            Relationlet r = (Relationlet)entry.getValue();
            Set<Var> varsMentioned = r.getVarsMentioned();
            for (Var v : varsMentioned) {
                varToRids.put((Object)v, (Object)id);
            }
        }
        Map<Integer, Set> clusterToVars = clusters.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Collection)e.getValue()).stream().map(Map.Entry::getValue).collect(Collectors.toSet())));
        Set set = materializedMembers.values().stream().map(Relationlet::getVarsMentioned).flatMap(Collection::stream).collect(Collectors.toSet());
        HashSet<Var> takenFinalVars = new HashSet<Var>();
        Set mentionedVars = set;
        Predicate<Var> isBlacklisted = baseBlacklist.or(mentionedVars::contains).or(takenFinalVars::contains);
        VarGeneratorImpl2 basegen = VarGeneratorImpl2.create();
        GeneratorBlacklist vargen = GeneratorBlacklist.create((Generator)basegen, isBlacklisted);
        HashBasedTable ridToVarToFinalVal = HashBasedTable.create();
        for (Map.Entry entry : clusters.entrySet()) {
            Object r;
            int n = (Integer)entry.getKey();
            Collection collection = (Collection)entry.getValue();
            LinkedHashSet<Var> linkedHashSet = new LinkedHashSet<Var>();
            ArrayListMultimap varToRe = ArrayListMultimap.create();
            for (Map.Entry f : collection) {
                String label = (String)f.getKey();
                r = (Relationlet)materializedMembers.get(label);
                NestedVarMap nvm = r.getNestedVarMap();
                Var v = (Var)f.getValue();
                varToRe.put((Object)v, (Object)label);
                boolean isFixed = nvm.isFixed(v);
                if (!isFixed) continue;
                linkedHashSet.add(v);
            }
            if (linkedHashSet.size() > 1) {
                Multimap conflictMentions = Multimaps.filterKeys((Multimap)varToRe, linkedHashSet::contains);
                throw new RuntimeException("Conflicting fixed vars encountered when processing join: " + String.valueOf(linkedHashSet) + " with mentions in " + String.valueOf(conflictMentions));
            }
            Var finalVar2 = null;
            boolean isFinalVarFixed = false;
            if (linkedHashSet.size() == 1) {
                finalVar2 = (Var)linkedHashSet.iterator().next();
                isFinalVarFixed = true;
            }
            if (finalVar2 == null) {
                Set usedVars = varToRe.keySet();
                r = usedVars.iterator();
                while (r.hasNext()) {
                    Var var = (Var)r.next();
                    if (takenFinalVars.contains(var)) continue;
                    finalVar2 = var;
                    break;
                }
            }
            if (finalVar2 == null) {
                finalVar2 = (Var)vargen.next();
            }
            takenFinalVars.add(finalVar2);
            for (Map.Entry ridvar : (Collection)clusters.get(n)) {
                String rid = (String)ridvar.getKey();
                Var var = (Var)ridvar.getValue();
                ridToVarToFinalVal.put((Object)rid, (Object)var, (Object)finalVar2);
                varToRids.remove((Object)var, (Object)rid);
            }
        }
        for (Map.Entry entry : varToRids.asMap().entrySet()) {
            boolean isFixed;
            Var var = (Var)entry.getKey();
            Collection collection = (Collection)entry.getValue();
            ArrayList arrayList = new ArrayList(materializedMembers.keySet());
            arrayList.retainAll(collection);
            for (String rid : arrayList) {
                isFixed = ((RelationletSimple)materializedMembers.get(rid)).getNestedVarMap().isFixed(var);
                if (!isFixed) continue;
                takenFinalVars.add(var);
                ridToVarToFinalVal.put((Object)rid, (Object)var, (Object)var);
            }
            for (String rid : arrayList) {
                isFixed = ((RelationletSimple)materializedMembers.get(rid)).getNestedVarMap().isFixed(var);
                if (isFixed) continue;
                boolean isTaken = takenFinalVars.contains(var);
                finalVar = isTaken ? (Var)vargen.next() : var;
                takenFinalVars.add(finalVar);
                ridToVarToFinalVal.put((Object)rid, (Object)var, (Object)finalVar);
            }
        }
        ElementGroup group = new ElementGroup();
        for (Map.Entry entry : materializedMembers.entrySet()) {
            String string = (String)entry.getKey();
            RelationletSimple relationletSimple = (RelationletSimple)entry.getValue();
            Element el = relationletSimple.getElement();
            Map originToFinal = ridToVarToFinalVal.row((Object)string);
            Element contrib = ElementUtils.applyNodeTransform((Element)el, (NodeTransform)new NodeTransformSubst(originToFinal));
            group.addElement(contrib);
        }
        LinkedHashMap<Var, Var> linkedHashMap = new LinkedHashMap<Var, Var>();
        for (Map.Entry<Var, VarRefStatic> entry : this.explicitExposedVars.entrySet()) {
            Var var = entry.getKey();
            VarRefStatic vr = entry.getValue();
            Map.Entry<String, Var> finalE = RelationletJoinerImpl.resolveMatCore(materializedMembers, vr);
            String rid = finalE.getKey();
            Var v = finalE.getValue();
            finalVar = (Var)ridToVarToFinalVal.get((Object)rid, (Object)v);
            Objects.requireNonNull(finalVar);
            linkedHashMap.put(var, finalVar);
        }
        LinkedHashMap<String, NestedVarMap> linkedHashMap2 = new LinkedHashMap<String, NestedVarMap>();
        for (Map.Entry entry : materializedMembers.entrySet()) {
            String label = (String)entry.getKey();
            NestedVarMap clone = ((RelationletSimple)entry.getValue()).getNestedVarMap().clone();
            Map memberMap = ridToVarToFinalVal.row((Object)label);
            clone.transformValues(memberMap::get);
            linkedHashMap2.put(label, clone);
        }
        Set<Var> set2 = materializedMembers.values().stream().flatMap(re -> re.getNestedVarMap().getFixedFinalVars().stream()).collect(Collectors.toSet());
        NestedVarMapImpl nestedVarMapImpl = new NestedVarMapImpl(linkedHashMap, set2, linkedHashMap2);
        ElementGroup finalElement = this.postProcessor == null ? group : this.postProcessor.apply((ElementGroup)group);
        RelationletNestedImpl result = new RelationletNestedImpl((Element)finalElement, nestedVarMapImpl, materializedMembers);
        return result;
    }

    @Override
    public Set<Var> getVarsMentioned() {
        Set<Var> result = this.labelToRe.values().stream().map(RelationletEntry::getRelationlet).map(Relationlet::getVarsMentioned).flatMap(Collection::stream).collect(Collectors.toSet());
        return result;
    }
}

