/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.facete.v3.api;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;

public class TreeDataMap<K, V>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<K, HierarchyWrapper<K, V>> itemToWrapperMap = new LinkedHashMap<K, HierarchyWrapper<K, V>>();

    public <O> TreeDataMap<O, V> mapKeys(Function<K, O> mapper) {
        TreeDataMap<K, V> result = new TreeDataMap<K, V>();
        TreeDataMap.mapKeys(this, null, result, null, mapper);
        return result;
    }

    private static <I, O, V> void mapKeys(TreeDataMap<I, V> treeData, I oldParent, TreeDataMap<O, V> result, O newParent, Function<I, O> mapper) {
        List<I> children = treeData.getChildren(oldParent);
        for (I child : children) {
            O newChild = mapper.apply(child);
            V value = treeData.get(child);
            result.addItem(newParent, newChild);
            result.put(newChild, value);
            TreeDataMap.mapKeys(treeData, child, result, newChild, mapper);
        }
    }

    public V get(Object key) {
        HierarchyWrapper<K, V> wrapper = this.itemToWrapperMap.get(key);
        V result = wrapper == null ? null : (V)wrapper.getValue();
        return result;
    }

    public V put(K key, V value) {
        HierarchyWrapper<K, V> wrapper = this.itemToWrapperMap.get(key);
        if (wrapper == null) {
            throw new NoSuchElementException();
        }
        V result = wrapper.getValue();
        wrapper.setValue(value);
        return result;
    }

    private void putItem(K item, K parent) {
        HierarchyWrapper wrappedItem = new HierarchyWrapper(parent, item);
        if (this.itemToWrapperMap.containsKey(parent)) {
            this.itemToWrapperMap.get(parent).addChild(item);
        }
        this.itemToWrapperMap.put(item, wrappedItem);
    }

    public TreeDataMap<K, V> putAll(TreeDataMap<K, V> other) {
        for (Map.Entry<K, HierarchyWrapper<K, V>> entry : other.itemToWrapperMap.entrySet()) {
            HierarchyWrapper<K, V> otherWrapper = entry.getValue();
            HierarchyWrapper<K, V> thisWrapper = this.itemToWrapperMap.get(entry.getKey());
            if (thisWrapper == null) {
                thisWrapper = new HierarchyWrapper<K, V>(otherWrapper.getParent(), entry.getKey(), otherWrapper.getValue(), new ArrayList<K>(otherWrapper.getChildren()));
                this.itemToWrapperMap.put(entry.getKey(), thisWrapper);
                continue;
            }
            Preconditions.checkState((boolean)Objects.equals(thisWrapper.getParent(), otherWrapper.getParent()), (Object)"Parents must be equal");
            thisWrapper.getChildren().addAll(otherWrapper.getChildren());
            thisWrapper.setValue(otherWrapper.getValue());
        }
        return this;
    }

    public TreeDataMap<K, V> cloneTree() {
        TreeDataMap<K, V> result = new TreeDataMap<K, V>();
        result.putAll(this);
        return result;
    }

    public TreeDataMap<K, V> addItems(Collection<K> rootItems, Function<K, ? extends Collection<K>> childItemProvider) {
        rootItems.forEach(item -> {
            this.addItem(null, item);
            Collection childItems = (Collection)childItemProvider.apply(item);
            this.addItems(item, childItems);
            this.addItemsRecursively(childItems, childItemProvider);
        });
        return this;
    }

    private void addItemsRecursively(Collection<K> items, Function<K, ? extends Collection<K>> childItemProvider) {
        items.forEach(item -> {
            Collection childItems = (Collection)childItemProvider.apply(item);
            this.addItems(item, childItems);
            this.addItemsRecursively(childItems, childItemProvider);
        });
    }

    public void putItem(K item, Function<? super K, ? extends K> getParent) {
        Preconditions.checkNotNull(item);
        if (!this.contains(item)) {
            K parent = getParent.apply(item);
            if (parent != null) {
                this.putItem(parent, getParent);
            }
            this.addItem(parent, item);
        }
    }

    public String toString() {
        return this.itemToWrapperMap.toString();
    }

    public TreeDataMap() {
        this.itemToWrapperMap.put(null, new HierarchyWrapper(null, null));
    }

    public TreeDataMap<K, V> addRootItems(K ... items) {
        this.addItems(null, items);
        return this;
    }

    public TreeDataMap<K, V> addRootItems(Collection<K> items) {
        this.addItems((K)null, items);
        return this;
    }

    public TreeDataMap<K, V> addRootItems(Stream<K> items) {
        this.addItems((K)null, items);
        return this;
    }

    public TreeDataMap<K, V> addItem(K parent, K item) {
        Objects.requireNonNull(item, "Item cannot be null");
        if (parent != null && !this.contains(parent)) {
            throw new IllegalArgumentException("Parent needs to be added before children. To add root items, call with parent as null");
        }
        if (this.contains(item)) {
            throw new IllegalArgumentException("Cannot add the same item multiple times: " + String.valueOf(item));
        }
        this.putItem(item, parent);
        return this;
    }

    public TreeDataMap<K, V> addItems(K parent, K ... items) {
        Arrays.stream(items).forEach(item -> this.addItem(parent, item));
        return this;
    }

    public TreeDataMap<K, V> addItems(K parent, Collection<K> items) {
        items.forEach(item -> this.addItem(parent, item));
        return this;
    }

    public TreeDataMap<K, V> addItems(K parent, Stream<K> items) {
        items.forEach(item -> this.addItem(parent, item));
        return this;
    }

    public TreeDataMap<K, V> removeItem(K item) {
        if (!this.contains(item)) {
            throw new IllegalArgumentException("Item '" + String.valueOf(item) + "' not in the hierarchy");
        }
        new ArrayList<K>(this.getChildren(item)).forEach((Consumer<K>)((Consumer<Object>)child -> this.removeItem(child)));
        this.itemToWrapperMap.get(this.itemToWrapperMap.get(item).getParent()).removeChild(item);
        if (item != null) {
            this.itemToWrapperMap.remove(item);
        }
        return this;
    }

    public TreeDataMap<K, V> clear() {
        this.removeItem(null);
        return this;
    }

    public List<K> getRootItems() {
        return this.getChildren(null);
    }

    public List<K> getChildren(K item) {
        if (!this.contains(item)) {
            throw new IllegalArgumentException("Item '" + String.valueOf(item) + "' not in the hierarchy");
        }
        return Collections.unmodifiableList(this.itemToWrapperMap.get(item).getChildren());
    }

    public K getParent(K item) {
        if (!this.contains(item)) {
            throw new IllegalArgumentException("Item '" + String.valueOf(item) + "' not in hierarchy");
        }
        return this.itemToWrapperMap.get(item).getParent();
    }

    public void setParent(K item, K parent) {
        if (!this.contains(item)) {
            throw new IllegalArgumentException("Item '" + String.valueOf(item) + "' not in the hierarchy");
        }
        if (parent != null && !this.contains(parent)) {
            throw new IllegalArgumentException("Parent needs to be added before children. To set as root item, call with parent as null");
        }
        if (item.equals(parent)) {
            throw new IllegalArgumentException("Item cannot be the parent of itself");
        }
        K oldParent = this.itemToWrapperMap.get(item).getParent();
        if (!Objects.equals(oldParent, parent)) {
            this.itemToWrapperMap.get(oldParent).removeChild(item);
            this.itemToWrapperMap.get(parent).addChild(item);
            this.itemToWrapperMap.get(item).setParent(parent);
        }
    }

    public void moveAfterSibling(K item, K sibling) {
        if (!this.contains(item)) {
            throw new IllegalArgumentException("Item '" + String.valueOf(item) + "' not in the hierarchy");
        }
        if (sibling == null) {
            List<K> children = this.itemToWrapperMap.get(this.getParent(item)).getChildren();
            children.remove(item);
            children.add(0, item);
        } else {
            if (!this.contains(sibling)) {
                throw new IllegalArgumentException("Item '" + String.valueOf(sibling) + "' not in the hierarchy");
            }
            K parent = this.itemToWrapperMap.get(item).getParent();
            if (!Objects.equals(parent, this.itemToWrapperMap.get(sibling).getParent())) {
                throw new IllegalArgumentException("Items '" + String.valueOf(item) + "' and '" + String.valueOf(sibling) + "' don't have the same parent");
            }
            List<K> children = this.itemToWrapperMap.get(parent).getChildren();
            children.remove(item);
            children.add(children.indexOf(sibling) + 1, item);
        }
    }

    public boolean contains(K item) {
        return this.itemToWrapperMap.containsKey(item);
    }

    private static class HierarchyWrapper<K, V>
    implements Map.Entry<K, V>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private K parent;
        private K key;
        private V value;
        private List<K> children;

        public HierarchyWrapper(K parent, K key) {
            this(parent, key, null, new ArrayList());
        }

        public HierarchyWrapper(K parent, K key, V value, List<K> children) {
            this.parent = parent;
            this.key = key;
            this.value = value;
            this.children = children;
        }

        public K getParent() {
            return this.parent;
        }

        public void setParent(K parent) {
            this.parent = parent;
        }

        public List<K> getChildren() {
            return this.children;
        }

        public void addChild(K child) {
            this.children.add(child);
        }

        public void removeChild(K child) {
            this.children.remove(child);
        }

        public String toString() {
            return this.children.toString();
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V result = this.value;
            this.value = value;
            return result;
        }
    }
}

