/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.facete.v3.api.path;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.aksw.jena_sparql_api.relationlet.VarRefStatic;
import org.apache.jena.sparql.core.Var;

public interface NestedVarMap {
    public Set<Var> getVarsMentioned();

    public NestedVarMap get(String var1);

    public void transformValues(Function<? super Var, ? extends Var> var1);

    public Set<Var> getFixedFinalVars();

    public Map<Var, Var> getLocalToFinalVarMap();

    public Map<String, NestedVarMap> getMemberVarMap();

    default public NestedVarMap get(String ... aliases) {
        NestedVarMap result = this.get(Arrays.asList(aliases));
        return result;
    }

    default public NestedVarMap get(List<String> aliases) {
        NestedVarMap result;
        if (aliases.isEmpty()) {
            result = this;
        } else {
            String alias = aliases.iterator().next();
            List<String> sublist = aliases.subList(1, aliases.size());
            result = this.get(alias).get(sublist);
        }
        return result;
    }

    default public boolean isFixed(Var var) {
        Set<Var> fixedVars = this.getFixedFinalVars();
        boolean result = fixedVars.contains(var);
        return result;
    }

    default public boolean isFixed(VarRefStatic varRef) {
        List<String> labels = varRef.getLabels();
        NestedVarMap nvm = this.get(labels);
        Var v = varRef.getV();
        boolean result = nvm.isFixed(v);
        return result;
    }

    public NestedVarMap clone();
}

