/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.facete.v3.api;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;

public class TreeData<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<T, HierarchyWrapper<T>> itemToWrapperMap = new LinkedHashMap<T, HierarchyWrapper<T>>();

    public <O> TreeData<O> map(Function<T, O> mapper) {
        TreeData<T> result = new TreeData<T>();
        TreeData.map(this, null, result, null, mapper);
        return result;
    }

    private static <I, O> void map(TreeData<I> treeData, I oldParent, TreeData<O> result, O newParent, Function<I, O> mapper) {
        List<I> children = treeData.getChildren(oldParent);
        for (I child : children) {
            O newChild = mapper.apply(child);
            result.addItem(newParent, newChild);
            TreeData.map(treeData, child, result, newChild, mapper);
        }
    }

    private void putItem(T item, T parent) {
        HierarchyWrapper<T> wrappedItem = new HierarchyWrapper<T>(parent);
        if (this.itemToWrapperMap.containsKey(parent)) {
            this.itemToWrapperMap.get(parent).addChild(item);
        }
        this.itemToWrapperMap.put(item, wrappedItem);
    }

    public TreeData<T> cloneTree() {
        TreeData<T> result = new TreeData<T>();
        for (Map.Entry<T, HierarchyWrapper<T>> entry : this.itemToWrapperMap.entrySet()) {
            HierarchyWrapper<T> original = entry.getValue();
            HierarchyWrapper<T> copy = new HierarchyWrapper<T>(original.getParent(), new ArrayList<T>(original.getChildren()));
            result.itemToWrapperMap.put(entry.getKey(), copy);
        }
        return result;
    }

    public TreeData<T> addItems(Collection<T> rootItems, Function<T, ? extends Collection<T>> childItemProvider) {
        rootItems.forEach(item -> {
            this.addItem(null, item);
            Collection childItems = (Collection)childItemProvider.apply(item);
            this.addItems(item, childItems);
            this.addItemsRecursively(childItems, childItemProvider);
        });
        return this;
    }

    private void addItemsRecursively(Collection<T> items, Function<T, ? extends Collection<T>> childItemProvider) {
        items.forEach(item -> {
            Collection childItems = (Collection)childItemProvider.apply(item);
            this.addItems(item, childItems);
            this.addItemsRecursively(childItems, childItemProvider);
        });
    }

    public void putItem(T item, Function<? super T, ? extends T> getParent) {
        Preconditions.checkNotNull(item);
        if (!this.contains(item)) {
            T parent = getParent.apply(item);
            if (parent != null) {
                this.putItem(parent, getParent);
            }
            this.addItem(parent, item);
        }
    }

    public String toString() {
        return this.itemToWrapperMap.toString();
    }

    public TreeData() {
        this.itemToWrapperMap.put(null, new HierarchyWrapper<Object>(null));
    }

    public TreeData<T> addRootItems(T ... items) {
        this.addItems(null, items);
        return this;
    }

    public TreeData<T> addRootItems(Collection<T> items) {
        this.addItems((T)null, items);
        return this;
    }

    public TreeData<T> addRootItems(Stream<T> items) {
        this.addItems((T)null, items);
        return this;
    }

    public TreeData<T> addItem(T parent, T item) {
        Objects.requireNonNull(item, "Item cannot be null");
        if (parent != null && !this.contains(parent)) {
            throw new IllegalArgumentException("Parent needs to be added before children. To add root items, call with parent as null");
        }
        if (this.contains(item)) {
            throw new IllegalArgumentException("Cannot add the same item multiple times: " + String.valueOf(item));
        }
        this.putItem(item, parent);
        return this;
    }

    public TreeData<T> addItems(T parent, T ... items) {
        Arrays.stream(items).forEach(item -> this.addItem(parent, item));
        return this;
    }

    public TreeData<T> addItems(T parent, Collection<T> items) {
        items.forEach(item -> this.addItem(parent, item));
        return this;
    }

    public TreeData<T> addItems(T parent, Stream<T> items) {
        items.forEach(item -> this.addItem(parent, item));
        return this;
    }

    public TreeData<T> removeItem(T item) {
        if (!this.contains(item)) {
            throw new IllegalArgumentException("Item '" + String.valueOf(item) + "' not in the hierarchy");
        }
        new ArrayList<T>(this.getChildren(item)).forEach(child -> this.removeItem(child));
        this.itemToWrapperMap.get(this.itemToWrapperMap.get(item).getParent()).removeChild(item);
        if (item != null) {
            this.itemToWrapperMap.remove(item);
        }
        return this;
    }

    public TreeData<T> clear() {
        this.removeItem(null);
        return this;
    }

    public List<T> getRootItems() {
        return this.getChildren(null);
    }

    public List<T> getChildren(T item) {
        if (!this.contains(item)) {
            throw new IllegalArgumentException("Item '" + String.valueOf(item) + "' not in the hierarchy");
        }
        return Collections.unmodifiableList(this.itemToWrapperMap.get(item).getChildren());
    }

    public T getParent(T item) {
        if (!this.contains(item)) {
            throw new IllegalArgumentException("Item '" + String.valueOf(item) + "' not in hierarchy");
        }
        return this.itemToWrapperMap.get(item).getParent();
    }

    public void setParent(T item, T parent) {
        if (!this.contains(item)) {
            throw new IllegalArgumentException("Item '" + String.valueOf(item) + "' not in the hierarchy");
        }
        if (parent != null && !this.contains(parent)) {
            throw new IllegalArgumentException("Parent needs to be added before children. To set as root item, call with parent as null");
        }
        if (item.equals(parent)) {
            throw new IllegalArgumentException("Item cannot be the parent of itself");
        }
        T oldParent = this.itemToWrapperMap.get(item).getParent();
        if (!Objects.equals(oldParent, parent)) {
            this.itemToWrapperMap.get(oldParent).removeChild(item);
            this.itemToWrapperMap.get(parent).addChild(item);
            this.itemToWrapperMap.get(item).setParent(parent);
        }
    }

    public void moveAfterSibling(T item, T sibling) {
        if (!this.contains(item)) {
            throw new IllegalArgumentException("Item '" + String.valueOf(item) + "' not in the hierarchy");
        }
        if (sibling == null) {
            List<T> children = this.itemToWrapperMap.get(this.getParent(item)).getChildren();
            children.remove(item);
            children.add(0, item);
        } else {
            if (!this.contains(sibling)) {
                throw new IllegalArgumentException("Item '" + String.valueOf(sibling) + "' not in the hierarchy");
            }
            T parent = this.itemToWrapperMap.get(item).getParent();
            if (!Objects.equals(parent, this.itemToWrapperMap.get(sibling).getParent())) {
                throw new IllegalArgumentException("Items '" + String.valueOf(item) + "' and '" + String.valueOf(sibling) + "' don't have the same parent");
            }
            List<T> children = this.itemToWrapperMap.get(parent).getChildren();
            children.remove(item);
            children.add(children.indexOf(sibling) + 1, item);
        }
    }

    public boolean contains(T item) {
        return this.itemToWrapperMap.containsKey(item);
    }

    private static class HierarchyWrapper<T>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private T parent;
        private List<T> children;

        public HierarchyWrapper(T parent) {
            this(parent, new ArrayList());
        }

        public HierarchyWrapper(T parent, List<T> children) {
            this.parent = parent;
            this.children = children;
        }

        public T getParent() {
            return this.parent;
        }

        public void setParent(T parent) {
            this.parent = parent;
        }

        public List<T> getChildren() {
            return this.children;
        }

        public void addChild(T child) {
            this.children.add(child);
        }

        public void removeChild(T child) {
            this.children.remove(child);
        }

        public String toString() {
            return this.children.toString();
        }
    }
}

