/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.facete.v3.api.traversal;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.aksw.facete.v3.api.AliasedPath;
import org.aksw.facete.v3.api.Direction;
import org.aksw.facete.v3.api.traversal.TraversalDirNode;
import org.aksw.facete.v3.api.traversal.TraversalMultiNode;
import org.aksw.jenax.path.core.FacetStep;
import org.aksw.jenax.sparql.path.SimplePath;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.sparql.path.P_Link;
import org.apache.jena.sparql.path.P_Path0;
import org.apache.jena.sparql.path.P_ReverseLink;
import org.apache.jena.sparql.path.P_Seq;
import org.apache.jena.sparql.path.Path;

public interface TraversalNode<N extends TraversalNode<N, D, M>, D extends TraversalDirNode<N, M>, M extends TraversalMultiNode<N>> {
    public D fwd();

    public D bwd();

    @Deprecated
    default public boolean canOpt() {
        return false;
    }

    @Deprecated
    default public M opt() {
        throw new UnsupportedOperationException("Optional traversal not implemented or not overridden");
    }

    default public M fwd(Property property) {
        return this.fwd().via((Resource)property);
    }

    default public M bwd(Property property) {
        return this.bwd().via((Resource)property);
    }

    default public M fwd(String p) {
        Property property = ResourceFactory.createProperty((String)p);
        return this.fwd().via((Resource)property);
    }

    default public M bwd(String p) {
        Property property = ResourceFactory.createProperty((String)p);
        return this.bwd().via((Resource)property);
    }

    default public M fwd(Node node) {
        return this.fwd().via((Resource)ResourceFactory.createProperty((String)node.getURI()));
    }

    default public M bwd(Node node) {
        return this.bwd().via((Resource)ResourceFactory.createProperty((String)node.getURI()));
    }

    default public D step(Direction direction) {
        return Direction.BACKWARD.equals((Object)direction) ? this.bwd() : this.fwd();
    }

    default public M step(String p, Direction direction) {
        return Direction.BACKWARD.equals((Object)direction) ? this.bwd(p) : this.fwd(p);
    }

    default public M step(Node p, Direction direction) {
        return Direction.BACKWARD.equals((Object)direction) ? this.bwd(p) : this.fwd(p);
    }

    default public M step(Property p, Direction direction) {
        return Direction.BACKWARD.equals((Object)direction) ? this.bwd(p) : this.fwd(p);
    }

    default public N step(FacetStep step) {
        return (N)((TraversalNode)this.step(step.getNode(), Direction.ofFwd(step.getDirection().isForward())).viaAlias(step.getAlias()));
    }

    @Deprecated
    default public N walk(AliasedPath path) {
        List steps = path.getSteps();
        N result = this.walkAliased(steps.iterator());
        return result;
    }

    @Deprecated
    default public N walkAliased(Iterator<? extends Map.Entry<P_Path0, String>> it) {
        TraversalNode<N, D, M> result;
        if (it.hasNext()) {
            Map.Entry<P_Path0, String> step = it.next();
            P_Path0 p = step.getKey();
            String alias = step.getValue();
            TraversalNode next = (TraversalNode)this.step(p.getNode(), Direction.ofFwd(p.isForward())).viaAlias(alias);
            result = next.walkAliased(it);
        } else {
            result = this;
        }
        return (N)result;
    }

    @Deprecated
    default public N walk(Path path) {
        TraversalNode<N, D, M> result;
        if (path == null) {
            result = this;
        } else if (path instanceof P_Seq) {
            P_Seq seq = (P_Seq)path;
            result = this.walk(seq.getLeft()).walk(seq.getRight());
        } else if (path instanceof P_Link) {
            P_Link link = (P_Link)path;
            result = (TraversalNode)this.fwd(link.getNode()).one();
        } else if (path instanceof P_ReverseLink) {
            P_ReverseLink reverseLink = (P_ReverseLink)path;
            result = (TraversalNode)this.bwd(reverseLink.getNode()).one();
        } else {
            throw new IllegalArgumentException("Unsupported path type " + String.valueOf(path) + " " + String.valueOf(Optional.ofNullable(path).map(Object::getClass).orElse(null)));
        }
        return (N)result;
    }

    @Deprecated
    default public N walk(SimplePath simplePath) {
        return this.walk(SimplePath.toPropertyPath((SimplePath)simplePath));
    }
}

