/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.facete.v3.api;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.aksw.facete.v3.api.PathBase;

public abstract class PathListBase<T extends PathBase<T, S>, S>
implements PathBase<T, S> {
    protected List<S> steps;

    public PathListBase(List<S> steps) {
        this.steps = steps;
    }

    @Override
    public List<S> getSteps() {
        return this.steps;
    }

    abstract T create(List<S> var1);

    @Override
    public T getParent() {
        T result = this.steps.isEmpty() ? null : (T)this.create(this.steps.subList(0, this.steps.size() - 1));
        return result;
    }

    @Override
    public S getLastStep() {
        Object result = this.steps.isEmpty() ? null : Iterables.getLast(this.steps);
        return (S)result;
    }

    @Override
    public T subPath(S step) {
        ArrayList<S> copy = new ArrayList<S>(this.steps);
        copy.add(step);
        T result = this.create(copy);
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.steps == null ? 0 : this.steps.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PathListBase other = (PathListBase)obj;
        return !(this.steps == null ? other.steps != null : !this.steps.equals(other.steps));
    }

    public String toString() {
        return Objects.toString(this.steps);
    }
}

