/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.http.repository.impl;

import java.nio.file.Path;
import java.util.Collection;
import org.aksw.jena_sparql_api.http.repository.api.RdfHttpEntityFile;
import org.aksw.jena_sparql_api.http.repository.api.RdfHttpResourceFile;
import org.aksw.jena_sparql_api.http.repository.api.ResourceStore;
import org.apache.jena.rdf.model.Resource;

public class RdfHttpResourceFileImpl
implements RdfHttpResourceFile {
    protected ResourceStore manager;
    protected Path path;

    public RdfHttpResourceFileImpl(ResourceStore manager, Path path) {
        this.manager = manager;
        this.path = path;
    }

    @Override
    public Collection<RdfHttpEntityFile> getEntities() {
        return this.manager.listEntities(this.path);
    }

    @Override
    public Path getRelativePath() {
        return this.path;
    }

    @Override
    public ResourceStore getResourceStore() {
        return this.manager;
    }

    @Override
    public RdfHttpEntityFile allocate(Resource description) {
        RdfHttpEntityFile result = this.getResourceStore().allocateEntity(this.path, description);
        return result;
    }

    @Override
    public RdfHttpResourceFile resolve(String path) {
        Path targetPath = this.getRelativePath().resolve(path);
        RdfHttpResourceFileImpl result = new RdfHttpResourceFileImpl(this.manager, targetPath);
        return result;
    }
}

