/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.conjure.fluent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.aksw.jena_sparql_api.conjure.dataset.algebra.Op;
import org.aksw.jena_sparql_api.conjure.dataset.algebra.OpConstruct;
import org.aksw.jena_sparql_api.conjure.dataset.algebra.OpHdtHeader;
import org.aksw.jena_sparql_api.conjure.dataset.algebra.OpPersist;
import org.aksw.jena_sparql_api.conjure.dataset.algebra.OpQueryOverViews;
import org.aksw.jena_sparql_api.conjure.dataset.algebra.OpSet;
import org.aksw.jena_sparql_api.conjure.dataset.algebra.OpStmtList;
import org.aksw.jena_sparql_api.conjure.dataset.algebra.OpUnionDefaultGraph;
import org.aksw.jena_sparql_api.conjure.dataset.algebra.OpUpdateRequest;
import org.aksw.jena_sparql_api.conjure.fluent.ConjureContext;
import org.aksw.jena_sparql_api.conjure.fluent.ConjureFluent;
import org.apache.jena.query.Query;

public class ConjureFluentImpl
implements ConjureFluent {
    protected ConjureContext context;
    protected Op op;

    public ConjureFluentImpl(ConjureContext context, Op op) {
        this.context = Objects.requireNonNull(context);
        this.op = Objects.requireNonNull(op);
    }

    public ConjureFluent wrap(Op op) {
        return new ConjureFluentImpl(this.context, op);
    }

    @Override
    public ConjureFluent construct(Collection<String> queryStrs) {
        ArrayList<String> validatedStrs = new ArrayList<String>();
        for (String str : queryStrs) {
            String validatedStr = this.context.getSparqlStmtParser().apply(str).toString();
            validatedStrs.add(validatedStr);
        }
        return this.wrap(OpConstruct.create(this.context.getModel(), this.op, validatedStrs));
    }

    @Override
    public ConjureFluent views(Collection<Query> queries) {
        List<String> strs = queries.stream().map(Object::toString).collect(Collectors.toList());
        ConjureFluent result = this.wrap(OpQueryOverViews.create(this.context.getModel(), this.op, strs));
        return result;
    }

    @Override
    public ConjureFluent views(String ... queryStrs) {
        ArrayList<String> validatedStrings = new ArrayList<String>();
        for (String queryStr : queryStrs) {
            String tmp = this.context.getSparqlStmtParser().apply(queryStr).toString();
            validatedStrings.add(tmp);
        }
        ConjureFluent result = this.wrap(OpQueryOverViews.create(this.context.getModel(), this.op, validatedStrings));
        return result;
    }

    @Override
    public ConjureFluent update(String updateRequest) {
        String validatedString = this.context.getSparqlStmtParser().apply(updateRequest).toString();
        return this.wrap(OpUpdateRequest.create(this.context.getModel(), this.op, validatedString));
    }

    @Override
    public Op getOp() {
        return this.op;
    }

    @Override
    public ConjureFluent hdtHeader() {
        return this.wrap(OpHdtHeader.create(this.context.getModel(), this.op));
    }

    @Override
    public ConjureFluent cache() {
        return this.wrap(OpPersist.create(this.context.getModel(), this.op));
    }

    @Override
    public ConjureFluent set(String ctxVarName, String selector, String path) {
        String parsedSelctor = this.context.getSparqlStmtParser().apply(selector).toString();
        return this.wrap(OpSet.create(this.context.getModel(), this.op, ctxVarName, null, parsedSelctor, path));
    }

    @Override
    public ConjureFluent stmts(Collection<String> stmtStrs) {
        ArrayList<String> validatedStrs = new ArrayList<String>();
        for (String str : stmtStrs) {
            String validatedStr = this.context.getSparqlStmtParser().apply(str).toString();
            validatedStrs.add(validatedStr);
        }
        return this.wrap(OpStmtList.create(this.context.getModel(), this.op, validatedStrs));
    }

    @Override
    public ConjureFluent unionDefaultGraph() {
        return this.wrap(OpUnionDefaultGraph.create(this.context.getModel(), this.op));
    }
}

