/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.conjure.entity.algebra;

import java.util.Objects;
import java.util.function.Function;
import org.aksw.jena_sparql_api.conjure.entity.algebra.HashUtils;
import org.aksw.jena_sparql_api.conjure.entity.algebra.OpCode;
import org.aksw.jena_sparql_api.conjure.entity.algebra.OpConvert;
import org.aksw.jena_sparql_api.conjure.entity.algebra.OpPath;
import org.aksw.jena_sparql_api.conjure.entity.algebra.OpValue;
import org.aksw.jena_sparql_api.conjure.entity.algebra.OpVisitor;

public abstract class HasherBase
implements OpVisitor<String> {
    @Override
    public String visit(OpCode op) {
        String result = HashUtils.computeHash(op.isDecode() != false ? "decode" : "encode", op.getSubOp().accept(this));
        return result;
    }

    @Override
    public String visit(OpConvert op) {
        String result = HashUtils.computeHash(op.getTargetContentType(), op.getSourceContentType(), op.getSubOp().accept(this));
        return result;
    }

    @Override
    public String visit(OpValue op) {
        Object value = op.getValue();
        String result = HashUtils.computeHash("value", Objects.toString(value));
        return result;
    }

    public static OpVisitor<String> create(final Function<OpPath, String> opPathToHash) {
        return new HasherBase(){

            @Override
            public String visit(OpPath op) {
                String result = (String)opPathToHash.apply(op);
                return result;
            }
        };
    }
}

