/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.conjure.dataset.engine;

import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.aksw.commons.util.reflect.ClassUtils;
import org.aksw.jena_sparql_api.algebra.transform.TransformUnionQuery2;
import org.aksw.jena_sparql_api.algebra.utils.VirtualPartitionedQuery;
import org.aksw.jena_sparql_api.common.DefaultPrefixes;
import org.aksw.jena_sparql_api.conjure.algebra.common.ResourceTreeUtils;
import org.aksw.jena_sparql_api.conjure.datapod.api.RdfDataPod;
import org.aksw.jena_sparql_api.conjure.datapod.impl.DataPods;
import org.aksw.jena_sparql_api.conjure.datapod.impl.RdfDataPodBase;
import org.aksw.jena_sparql_api.conjure.datapod.impl.RdfDataPodHdt;
import org.aksw.jena_sparql_api.conjure.dataref.rdf.api.RdfDataRef;
import org.aksw.jena_sparql_api.conjure.dataset.algebra.Op;
import org.aksw.jena_sparql_api.conjure.dataset.algebra.OpCoalesce;
import org.aksw.jena_sparql_api.conjure.dataset.algebra.OpConstruct;
import org.aksw.jena_sparql_api.conjure.dataset.algebra.OpData;
import org.aksw.jena_sparql_api.conjure.dataset.algebra.OpDataRefResource;
import org.aksw.jena_sparql_api.conjure.dataset.algebra.OpError;
import org.aksw.jena_sparql_api.conjure.dataset.algebra.OpHdtHeader;
import org.aksw.jena_sparql_api.conjure.dataset.algebra.OpJavaRewrite;
import org.aksw.jena_sparql_api.conjure.dataset.algebra.OpJobInstance;
import org.aksw.jena_sparql_api.conjure.dataset.algebra.OpMacroCall;
import org.aksw.jena_sparql_api.conjure.dataset.algebra.OpPersist;
import org.aksw.jena_sparql_api.conjure.dataset.algebra.OpQueryOverViews;
import org.aksw.jena_sparql_api.conjure.dataset.algebra.OpSequence;
import org.aksw.jena_sparql_api.conjure.dataset.algebra.OpSet;
import org.aksw.jena_sparql_api.conjure.dataset.algebra.OpStmtList;
import org.aksw.jena_sparql_api.conjure.dataset.algebra.OpUnion;
import org.aksw.jena_sparql_api.conjure.dataset.algebra.OpUnionDefaultGraph;
import org.aksw.jena_sparql_api.conjure.dataset.algebra.OpUpdateRequest;
import org.aksw.jena_sparql_api.conjure.dataset.algebra.OpUtils;
import org.aksw.jena_sparql_api.conjure.dataset.algebra.OpVar;
import org.aksw.jena_sparql_api.conjure.dataset.algebra.OpVisitor;
import org.aksw.jena_sparql_api.conjure.dataset.algebra.OpWhen;
import org.aksw.jena_sparql_api.conjure.dataset.engine.TaskContext;
import org.aksw.jena_sparql_api.conjure.fluent.JobUtils;
import org.aksw.jena_sparql_api.conjure.job.api.Job;
import org.aksw.jena_sparql_api.conjure.job.api.JobInstance;
import org.aksw.jena_sparql_api.conjure.noderef.NodeRef;
import org.aksw.jena_sparql_api.conjure.traversal.engine.FunctionAssembler;
import org.aksw.jena_sparql_api.http.repository.api.HttpResourceRepositoryFromFileSystem;
import org.aksw.jena_sparql_api.http.repository.api.RdfHttpEntityFile;
import org.aksw.jena_sparql_api.http.repository.api.ResourceStore;
import org.aksw.jena_sparql_api.http.repository.impl.HttpResourceRepositoryFromFileSystemImpl;
import org.aksw.jena_sparql_api.http.repository.impl.ResourceStoreImpl;
import org.aksw.jenax.arq.util.node.NodeEnvsubst;
import org.aksw.jenax.arq.util.syntax.QueryUtils;
import org.aksw.jenax.dataaccess.sparql.connection.common.RDFConnectionBuilder;
import org.aksw.jenax.dataaccess.sparql.connection.common.RDFConnectionUtils;
import org.aksw.jenax.dataaccess.sparql.datasource.RDFDataSource;
import org.aksw.jenax.dataaccess.sparql.datasource.RDFDataSourceWrapper;
import org.aksw.jenax.dataaccess.sparql.datasource.RdfDataSourceTransform;
import org.aksw.jenax.dataaccess.sparql.datasource.RdfDataSourceTransforms;
import org.aksw.jenax.dataaccess.sparql.pod.RDFDataPods;
import org.aksw.jenax.sparql.query.rx.SparqlRx;
import org.aksw.jenax.stmt.core.SparqlStmt;
import org.aksw.jenax.stmt.core.SparqlStmtMgr;
import org.aksw.jenax.stmt.core.SparqlStmtParser;
import org.aksw.jenax.stmt.core.SparqlStmtParserImpl;
import org.aksw.jenax.stmt.core.SparqlStmtTransform;
import org.aksw.jenax.stmt.core.SparqlStmtTransforms;
import org.aksw.jenax.stmt.resultset.SPARQLResultSinkQuads;
import org.aksw.jenax.stmt.resultset.SPARQLResultVisitor;
import org.aksw.jenax.stmt.util.SparqlStmtUtils;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.jena.atlas.lib.Sink;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdfconnection.RDFConnection;
import org.apache.jena.rdfconnection.SparqlQueryConnection;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.lang.SinkQuadsToDataset;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.algebra.Transform;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.BindingBuilder;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprTransform;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.sparql.path.PathParser;
import org.apache.jena.sparql.util.ExprUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpExecutorDefault
implements OpVisitor<RdfDataPod> {
    protected static final Logger logger = LoggerFactory.getLogger(OpExecutorDefault.class);
    protected RDFFormat persistRdfFormat;
    protected Dataset dataset;
    protected HttpResourceRepositoryFromFileSystemImpl repo;
    protected TaskContext taskContext;
    protected boolean isDryRun;
    protected Map<String, Node> execCtx;

    public OpExecutorDefault(Dataset dataset, HttpResourceRepositoryFromFileSystem repo, TaskContext taskContext, Map<String, Node> execCtx, RDFFormat persistRdfFormat) {
        this.dataset = dataset;
        this.repo = (HttpResourceRepositoryFromFileSystemImpl)repo;
        this.taskContext = Objects.requireNonNull(taskContext);
        this.execCtx = execCtx;
        this.persistRdfFormat = persistRdfFormat;
    }

    public TaskContext getTaskContext() {
        return this.taskContext;
    }

    public <T extends RDFNode> RdfDataPod wrapWithGetFromHash(T op, Function<T, RdfDataPod> generator) {
        String hash = ResourceTreeUtils.createGenericHash(op).toString();
        RdfDataPod result = DataPods.create(hash, this.repo);
        return result;
    }

    @Override
    public RdfDataPod visit(OpDataRefResource op) {
        RdfDataRef dataRef = op.getDataRef();
        RdfDataPod result = DataPods.fromDataRef(dataRef, this.dataset, this.repo, this);
        return result;
    }

    @Override
    public RdfDataPod visit(OpData op) {
        Object data = null;
        RdfDataPod result = DataPods.fromData(data);
        return result;
    }

    public Node substNode(Node node) {
        Node r = NodeEnvsubst.substWithNode((Node)node, this.execCtx::get);
        r = r.isVariable() ? this.execCtx.getOrDefault(r.getName(), r) : r;
        return r;
    }

    @Override
    public RdfDataPod visit(OpConstruct op) {
        RdfDataPod result;
        Op subOp = op.getSubOp();
        try (RdfDataPod subDataPod = subOp.accept(this);
             RDFConnection tmpConn = subDataPod.getConnection();){
            RDFConnection conn = RDFConnectionUtils.enableRelativeIrisInQueryResults((RDFConnection)tmpConn);
            Set<String> queryStrs = op.getQueryStrings();
            Model model = ModelFactory.createDefaultModel();
            for (String queryStr : queryStrs) {
                Query query = QueryFactory.create((String)queryStr);
                Query effQuery = QueryUtils.applyNodeTransform((Query)query, this::substNode);
                logger.info("Query after env-var substitution: " + String.valueOf(effQuery));
                Model contrib = conn.queryConstruct(effQuery);
                model.add(contrib);
            }
            result = DataPods.fromModel(model);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    @Override
    public RdfDataPod visit(OpUpdateRequest op) {
        Op subOp = op.getSubOp();
        RdfDataPod subDataPod = subOp.accept(this);
        try (RDFConnection conn = subDataPod.getConnection();){
            for (String updateRequestStr : op.getUpdateRequests()) {
                conn.update(updateRequestStr);
            }
        }
        return subDataPod;
    }

    @Override
    public RdfDataPod visit(OpUnion op) {
        List<Op> subOps = op.getSubOps();
        Model model = ModelFactory.createDefaultModel();
        for (Op subOp : subOps) {
            try {
                RdfDataPod subDataPod = subOp.accept(this);
                try {
                    RDFConnection conn = subDataPod.getConnection();
                    try {
                        Model contribModel = conn.queryConstruct("CONSTRUCT WHERE { ?s ?p ?o }");
                        model.add(contribModel);
                    }
                    finally {
                        if (conn == null) continue;
                        conn.close();
                    }
                }
                finally {
                    if (subDataPod == null) continue;
                    subDataPod.close();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        RdfDataPod result = DataPods.fromModel(model);
        return result;
    }

    @Override
    public RdfDataPod visit(OpPersist op) {
        HashCode completeHash = OpExecutorDefault.computeOpHash(op, this.taskContext);
        String hashStr = completeHash.toString();
        ResourceStore hashStore = this.repo.getHashStore();
        HttpUriRequest baseRequest = RequestBuilder.get((String)hashStr).setHeader("Accept", "application/x-hdt").setHeader("Accept-Encoding", "identity,bzip2,gzip").build();
        RdfDataPod result = null;
        HttpRequest effectiveRequest = HttpResourceRepositoryFromFileSystemImpl.expandHttpRequest((HttpRequest)baseRequest);
        logger.info("Expanded HTTP Request: " + String.valueOf(effectiveRequest));
        try {
            RdfHttpEntityFile entity = this.repo.get(effectiveRequest, null);
            if (entity != null) {
                String pathStr = entity.getAbsolutePath().toString();
                result = DataPods.fromUrl(pathStr);
            }
        }
        catch (IOException e1) {
            throw new RuntimeException(e1);
        }
        if (result == null) {
            Op subOp = op.getSubOp();
            try (RdfDataPod pod = subOp.accept(this);){
                Model m;
                try {
                    m = ResourceStoreImpl.requestModel(this.repo, hashStore, hashStr, this.persistRdfFormat, () -> pod.getModel()).getValue();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                result = DataPods.fromModel(m);
            }
            catch (Exception e1) {
                throw new RuntimeException(e1);
            }
        }
        return result;
    }

    public static HashCode computeOpHash(OpPersist op, TaskContext taskContext) {
        HashFunction hashFn = Hashing.sha256();
        Op semanticSubOp = OpUtils.stripCache(op);
        HashCode subOpHash = ResourceTreeUtils.createGenericHash((RDFNode)semanticSubOp);
        HashCode inputRecordHash = ResourceTreeUtils.createGenericHash((RDFNode)taskContext.getInputRecord());
        List dataRefHashes = taskContext.getDataRefMapping().entrySet().stream().map(e -> Hashing.combineOrdered(Arrays.asList(Hashing.sha256().hashString((CharSequence)e.getKey(), StandardCharsets.UTF_8), ResourceTreeUtils.createGenericHash((RDFNode)e.getValue())))).collect(Collectors.toList());
        if (dataRefHashes.isEmpty()) {
            dataRefHashes.add(hashFn.hashInt(0));
        }
        HashCode dataRefHash = Hashing.combineUnordered(dataRefHashes);
        List ctxModelHashes = taskContext.getCtxModels().entrySet().stream().map(e -> Hashing.combineOrdered(Arrays.asList(hashFn.hashString((CharSequence)e.getKey(), StandardCharsets.UTF_8), ResourceTreeUtils.generateModelHash((Model)e.getValue(), hashFn)))).collect(Collectors.toList());
        if (ctxModelHashes.isEmpty()) {
            ctxModelHashes.add(hashFn.hashInt(0));
        }
        HashCode ctxModelsHash = Hashing.combineUnordered(ctxModelHashes);
        HashCode completeHash = Hashing.combineOrdered(Arrays.asList(subOpHash, inputRecordHash, ctxModelsHash, dataRefHash));
        return completeHash;
    }

    @Override
    public RdfDataPod visit(OpVar op) {
        String varName = op.getName();
        Map<String, Op> map = this.taskContext.getDataRefMapping();
        Op dataRef = map.get(varName);
        Objects.requireNonNull(dataRef, String.format("OpVar %s is unbound", varName));
        RdfDataPod result = dataRef.accept(this);
        return result;
    }

    @Override
    public RdfDataPod visit(OpCoalesce op) {
        List<Op> subOps = op.getSubOps();
        RdfDataPod result = null;
        for (Op subOp : subOps) {
            result = subOp.accept(this);
            RDFConnection conn = result.getConnection();
            try {
                Model contribModel = conn.queryConstruct("CONSTRUCT WHERE { ?s ?p ?o } LIMIT 1");
                if (contribModel.isEmpty()) continue;
                break;
            }
            finally {
                if (conn == null) continue;
                conn.close();
            }
        }
        if (result == null) {
            result = DataPods.empty();
        }
        return result;
    }

    @Override
    public RdfDataPod visit(OpHdtHeader op) {
        RdfDataPod result;
        Op subOp = op.getSubOp();
        try (RdfDataPod subDataPod = subOp.accept(this);){
            result = subDataPod instanceof RdfDataPodHdt ? ((RdfDataPodHdt)subDataPod).headerPod() : DataPods.empty();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    @Override
    public RdfDataPod visit(OpSequence op) {
        RdfDataPod result = null;
        List<Op> subOps = op.getSubOps();
        int n = subOps.size();
        for (int i = 0; i < n; ++i) {
            boolean isLast = i + 1 == n;
            Op subOp = subOps.get(i);
            RdfDataPod tmp = subOp.accept(this);
            if (isLast) {
                result = tmp;
                continue;
            }
            try {
                tmp.close();
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (result == null) {
            result = DataPods.empty();
        }
        return result;
    }

    @Override
    public RdfDataPod visit(OpSet op) {
        Op subOp = op.getSubOp();
        RdfDataPod result = subOp.accept(this);
        String ctxVarName = Objects.requireNonNull(op.getCtxVarName());
        String queryStr = Objects.requireNonNull(op.getSelector());
        String selVarName = op.getSelectorVarName();
        String pathStr = op.getPropertyPath();
        Path path = pathStr == null ? null : PathParser.parse((String)pathStr, (PrefixMapping)PrefixMapping.Extended);
        Query query = null;
        if (selVarName == null) {
            query = QueryFactory.create((String)queryStr);
            List resultVars = query.getResultVars();
            if (resultVars.size() != 1) {
                throw new RuntimeException("Require exactly 1 selector result var");
            }
            selVarName = (String)resultVars.get(0);
        }
        try (RDFConnection conn = result.getConnection();){
            String selVarN = selVarName;
            RDFNode node = (RDFNode)SparqlRx.execSelect((SparqlQueryConnection)conn, (String)queryStr).map(qs -> qs.get(selVarN)).firstElement().blockingGet();
            if (path != null) {
                Set<RDFNode> tgts = FunctionAssembler.execPath(conn, node, path);
                node = tgts.isEmpty() ? null : tgts.iterator().next();
            }
            Node n = node == null ? null : node.asNode();
            Node priorValue = this.execCtx.get(ctxVarName);
            logger.info("Updating ctx[" + ctxVarName + "] = " + String.valueOf(n) + " <- " + String.valueOf(priorValue));
            this.execCtx.put(ctxVarName, n);
        }
        catch (Exception e) {
            try {
                result.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new RuntimeException(e);
        }
        return result;
    }

    @Override
    public RdfDataPod visit(OpWhen op) {
        String conditionStr = op.getCondition();
        Expr expr = ExprUtils.parse((String)conditionStr);
        BindingBuilder binding = BindingFactory.builder();
        for (Map.Entry<String, Node> e : this.execCtx.entrySet()) {
            String k = e.getKey();
            Node v = e.getValue();
            if (v == null) continue;
            binding.add(Var.alloc((String)k), v);
        }
        NodeValue val = ExprUtils.eval((Expr)expr);
        Op subOp = val.getBoolean() ? op.getLhs() : op.getRhs();
        subOp = subOp == null ? OpData.create(ModelFactory.createDefaultModel()) : subOp;
        RdfDataPod result = subOp.accept(this);
        return result;
    }

    @Override
    public RdfDataPod visit(OpError op) {
        throw new RuntimeException("Reached a user error state, user specified reason was: " + op.getReason());
    }

    @Override
    public RdfDataPod visit(OpMacroCall op) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public RdfDataPod visit(OpQueryOverViews op) {
        Op subOp = op.getSubOp();
        final RdfDataPod subPod = subOp.accept(this);
        final ArrayList views = new ArrayList();
        List<String> viewDefs = op.getViewDefs();
        for (String viewDef : viewDefs) {
            try (ByteArrayInputStream in = new ByteArrayInputStream(viewDef.getBytes());){
                List queries;
                try {
                    queries = SparqlStmtMgr.loadQueries((InputStream)in, (PrefixMapping)DefaultPrefixes.get());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                for (Query query : queries) {
                    Collection viewContribs = VirtualPartitionedQuery.toViews((Query)query);
                    views.addAll(viewContribs);
                }
            }
            catch (IOException e1) {
                throw new RuntimeException(e1);
            }
        }
        RdfDataPodBase result = new RdfDataPodBase(){

            @Override
            protected RDFConnection newConnection() {
                RDFConnection raw = subPod.getConnection();
                RDFConnection result = (RDFConnection)RDFConnectionBuilder.from((RDFConnection)raw).addQueryTransform(q -> VirtualPartitionedQuery.rewrite((Collection)views, (Query)q)).getConnection();
                return result;
            }

            @Override
            public boolean isMutable() {
                return false;
            }

            @Override
            public void close() throws Exception {
                subPod.close();
            }
        };
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RdfDataPod visit(OpStmtList op) {
        Dataset resultDataset = DatasetFactory.create();
        RdfDataPod result = DataPods.fromDataset(resultDataset);
        Op subOp = op.getSubOp();
        try (RdfDataPod subPod = subOp.accept(this);){
            Model model = subPod.getModel();
            resultDataset.setDefaultModel(model);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        SinkQuadsToDataset tmp = new SinkQuadsToDataset(true, resultDataset.asDatasetGraph());
        SPARQLResultSinkQuads sink = new SPARQLResultSinkQuads((Sink)tmp);
        SparqlStmtParser parser = SparqlStmtParser.wrapWithOptimizePrefixes((Function)SparqlStmtParserImpl.create((PrefixMapping)DefaultPrefixes.get()));
        try (RDFConnection conn = result.getConnection();){
            List<String> stmts = op.getStmts();
            for (String stmt : stmts) {
                SparqlStmt before = (SparqlStmt)parser.apply((Object)stmt);
                SparqlStmt after = SparqlStmtUtils.applyNodeTransform((SparqlStmt)before, this::substNode);
                SparqlStmtUtils.process((RDFConnection)conn, (SparqlStmt)after, null, (SPARQLResultVisitor)sink);
            }
        }
        finally {
            tmp.close();
        }
        return result;
    }

    @Override
    public RdfDataPod visit(OpJobInstance op) {
        OpExecutorDefault subExecutor = new OpExecutorDefault(this.dataset, this.repo, this.taskContext, new LinkedHashMap<String, Node>(), this.persistRdfFormat);
        JobInstance ji = op.getJobInstance();
        Map<String, Node> envMap = ji.getEnvMap();
        Map<String, Op> opMap = ji.getOpVarMap();
        subExecutor.getExecCtx().putAll(envMap);
        subExecutor.getTaskContext().getDataRefMapping().putAll(opMap);
        NodeRef jobRef = ji.getJobRef();
        Job job = ji.getJob();
        if (job == null) {
            if (jobRef == null) {
                throw new RuntimeException("Neither job nor reference to a job set on job instance " + String.valueOf(ji));
            }
            RdfDataRef dataRef = jobRef.getDataRef();
            RdfDataPod jobDataPod = DataPods.fromDataRef(dataRef, this.dataset, this.repo, this);
            Model jobModel = jobDataPod.getModel();
            Node jobNode = jobRef.getNode();
            job = jobNode == null ? JobUtils.getOnlyJob(jobModel) : (Job)jobModel.asRDFNode(jobNode).as(Job.class);
        } else if (jobRef != null) {
            logger.warn("Both job and jobRef provided; using the former");
        }
        Op subOp = Objects.requireNonNull(job.getOp(), "Job does not have an operation set");
        RdfDataPod result = subOp.accept(subExecutor);
        return result;
    }

    public Map<String, Node> getExecCtx() {
        return this.execCtx;
    }

    @Override
    public RdfDataPod visit(OpUnionDefaultGraph op) {
        Op subOp = op.getSubOp();
        final RdfDataPod subPod = subOp.accept(this);
        RdfDataPodBase result = new RdfDataPodBase(){

            @Override
            protected RDFConnection newConnection() {
                RDFConnection raw = subPod.getConnection();
                RDFConnection result = (RDFConnection)RDFConnectionBuilder.from((RDFConnection)raw).addQueryTransform(q -> QueryUtils.applyOpTransform((Query)q, TransformUnionQuery2::transform)).getConnection();
                return result;
            }

            @Override
            public boolean isMutable() {
                return false;
            }

            @Override
            public synchronized void close() throws Exception {
                subPod.close();
            }
        };
        return result;
    }

    @Override
    public RdfDataPod visit(OpJavaRewrite op) {
        RdfDataPod subPod;
        Op subOp = op.getSubOp();
        RdfDataPod tmp = subPod = subOp.accept(this);
        for (OpJavaRewrite.Rewrite rewrite : op.getRewrites()) {
            RdfDataSourceTransform dataSourceTransform;
            String javaClass = rewrite.getJavaClass();
            try {
                dataSourceTransform = this.createTransformRdfDataSource(javaClass);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            RDFDataSource before = tmp.getDataSource();
            RDFDataSource after = (RDFDataSource)dataSourceTransform.apply((Object)before);
            tmp = RDFDataPods.of((RDFDataSource)after, tmp::close);
        }
        final RdfDataPod engine = tmp;
        RdfDataPodBase result = new RdfDataPodBase(){

            @Override
            protected RDFConnection newConnection() {
                return engine.getDataSource().getConnection();
            }

            @Override
            public synchronized void close() throws Exception {
                engine.close();
            }
        };
        return result;
    }

    public RdfDataSourceTransform createTransformRdfDataSource(String className) throws NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, ClassNotFoundException {
        Class<?> cls = Class.forName(className);
        return this.createTransformRdfDataSource(cls);
    }

    public RdfDataSourceTransform createTransformRdfDataSource(Class<?> cls) throws NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        RdfDataSourceTransform result;
        if (Transform.class.isAssignableFrom(cls)) {
            Supplier opTransformSupplier = ClassUtils.supplierFromCtor(cls, (boolean)true);
            SparqlStmtTransform stmtTransform = SparqlStmtTransforms.of((Supplier)opTransformSupplier);
            result = RdfDataSourceTransforms.of((SparqlStmtTransform)stmtTransform);
        } else if (ExprTransform.class.isAssignableFrom(cls)) {
            Supplier exprTransformSupplier = ClassUtils.supplierFromCtor(cls, (boolean)true);
            SparqlStmtTransform stmtTransform = SparqlStmtTransforms.ofExprTransform((Supplier)exprTransformSupplier);
            result = RdfDataSourceTransforms.of((SparqlStmtTransform)stmtTransform);
        } else if (SparqlStmtTransform.class.isAssignableFrom(cls)) {
            Constructor<?> ctor = cls.getConstructor(new Class[0]);
            Object inst = ctor.newInstance(new Object[0]);
            SparqlStmtTransform stmtTransform = (SparqlStmtTransform)inst;
            result = RdfDataSourceTransforms.of((SparqlStmtTransform)stmtTransform);
        } else if (RDFDataSourceWrapper.class.isAssignableFrom(cls)) {
            Constructor<?> ctor = cls.getConstructor(RDFDataSource.class);
            result = tmp -> {
                Object inst;
                try {
                    inst = ctor.newInstance(tmp);
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
                RDFDataSource r = (RDFDataSource)inst;
                return r;
            };
        } else if (RdfDataSourceTransform.class.isAssignableFrom(cls)) {
            Constructor<?> ctor = cls.getConstructor(new Class[0]);
            Object inst = ctor.newInstance(new Object[0]);
            result = (RdfDataSourceTransform)inst;
        } else {
            throw new RuntimeException("Unsupported transformation type: " + String.valueOf(cls));
        }
        return result;
    }
}

