/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.conjure.datapod.impl;

import com.google.common.collect.Sets;
import java.util.Set;
import org.aksw.jena_sparql_api.conjure.datapod.api.RdfDataPod;
import org.aksw.jenax.dataaccess.sparql.datasource.RDFDataSource;
import org.apache.jena.rdfconnection.RDFConnection;
import org.apache.jena.rdfconnection.RDFConnectionWrapper;

public abstract class RdfDataPodBase
implements RdfDataPod {
    protected Set<RDFConnection> openConnections = Sets.newIdentityHashSet();
    protected boolean isClosed = false;

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public synchronized void close() throws Exception {
        if (!this.isClosed) {
            this.isClosed = true;
            if (!this.openConnections.isEmpty()) {
                throw new RuntimeException("DataPod was closed, however " + this.openConnections.size() + " connections were still open");
            }
        }
    }

    @Override
    public synchronized RDFConnection getConnection() {
        RDFConnection core = this.newConnection();
        final RDFConnection[] newConnection = new RDFConnection[]{null};
        newConnection[0] = new RDFConnectionWrapper(core){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void close() {
                RdfDataPodBase rdfDataPodBase = RdfDataPodBase.this;
                synchronized (rdfDataPodBase) {
                    RdfDataPodBase.this.openConnections.remove(newConnection[0]);
                }
                super.close();
            }
        };
        return newConnection[0];
    }

    @Override
    public RDFDataSource getDataSource() {
        return () -> this.newConnection();
    }

    protected abstract RDFConnection newConnection();
}

