/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.http.repository.api;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Consumer;
import org.aksw.dcat.ap.domain.api.Checksum;
import org.aksw.jena_sparql_api.http.domain.api.RdfEntityInfo;
import org.aksw.jena_sparql_api.http.repository.api.RdfHttpEntityFile;
import org.aksw.jena_sparql_api.http.repository.api.RdfHttpResourceFile;
import org.apache.jena.rdf.model.Resource;

public interface ResourceStore {
    public static String readHash(RdfHttpEntityFile entity, String hashName) {
        RdfEntityInfo info = (RdfEntityInfo)entity.getCombinedInfo().as(RdfEntityInfo.class);
        Checksum hashInfo = info.getHash(hashName);
        String result = Optional.ofNullable(hashInfo).map(Checksum::getChecksum).orElse(null);
        return result;
    }

    public RdfHttpEntityFile putWithMove(String var1, RdfEntityInfo var2, Path var3) throws IOException;

    public RdfHttpEntityFile getEntityForPath(Path var1);

    public RdfHttpResourceFile getResource(String var1);

    public RdfHttpEntityFile allocateEntity(String var1, Resource var2);

    public Path getAbsolutePath();

    public Collection<RdfHttpEntityFile> listEntities(Path var1);

    public boolean contains(Path var1);

    public Resource getInfo(Path var1, String var2);

    public void updateInfo(Path var1, Consumer<? super Resource> var2);

    default public Resource getInfo(Path path) {
        Resource result = this.getInfo(path, null);
        return result;
    }

    public RdfHttpEntityFile allocateEntity(Path var1, Resource var2);
}

