/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.http.repository.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.aksw.jena_sparql_api.http.repository.api.PathAnnotatorRdf;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFWriterI;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.util.ResourceUtils;

public class PathAnnotatorRdfImpl
implements PathAnnotatorRdf {
    protected Cache<Path, Resource> cache = CacheBuilder.newBuilder().maximumSize(64L).build();
    protected String suffix = ".meta";

    @Override
    public Resource getRecord(Path path) {
        Resource result;
        try {
            result = (Resource)this.cache.get((Object)path, () -> this.getRecordUncached(path));
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public Resource getRecordUncached(Path path) {
        Resource result;
        if (Files.exists(path, new LinkOption[0])) {
            path = path.toAbsolutePath().normalize();
            Path parent = path.getParent();
            if (!Files.isRegularFile(path, new LinkOption[0])) {
                throw new RuntimeException("Folder metadata not supported (yet)");
            }
            String localName = path.getFileName().toString();
            Path metadata = parent.resolve(localName + this.suffix);
            String base = parent.normalize().toUri().toString();
            Model m = ModelFactory.createDefaultModel();
            if (Files.exists(metadata, new LinkOption[0])) {
                RDFDataMgr.read((Model)m, (String)metadata.toString(), (String)base, (Lang)Lang.TURTLE);
            }
            result = m.createResource(base + localName);
        } else {
            result = null;
        }
        return result;
    }

    @Override
    public Resource setRecord(Path path, Resource info) {
        Resource result;
        if (Files.exists(path, new LinkOption[0])) {
            path = path.toAbsolutePath().normalize();
            Path parent = path.getParent();
            if (!Files.isRegularFile(path, new LinkOption[0])) {
                throw new RuntimeException("Folder metadata not supported (yet)");
            }
            String localName = path.getFileName().toString();
            Path metadata = parent.resolve(localName + this.suffix);
            String base = parent.normalize().toUri().toString();
            Model copy = ModelFactory.createDefaultModel();
            copy.add(info.getModel());
            Resource cpy = info.inModel(copy);
            result = ResourceUtils.renameResource((Resource)cpy, (String)(base + localName));
            if (cpy.getModel().isEmpty()) {
                try {
                    Files.delete(metadata);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            RDFWriterI writer = copy.getWriter("ttl-nb");
            try (OutputStream out = Files.newOutputStream(metadata, new OpenOption[0]);){
                writer.write(copy, out, base);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.cache.put((Object)path, (Object)result);
        } else {
            result = null;
        }
        return result;
    }

    @Override
    public Collection<Path> isAnnotationFor(Path path) {
        Set<Path> result;
        String suffix;
        String fileName = path.getFileName().toString();
        if (fileName.endsWith(suffix = ".meta")) {
            Path parent = path.getParent();
            String targetFileName = fileName.substring(0, fileName.length() - suffix.length());
            Path tmp = parent.resolve(targetFileName);
            result = Collections.singleton(tmp);
        } else {
            result = Collections.emptySet();
        }
        return result;
    }
}

