/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.conjure.job.api;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.aksw.jena_sparql_api.conjure.dataset.algebra.Op;
import org.aksw.jena_sparql_api.conjure.job.api.JobBinding;
import org.aksw.jena_sparql_api.conjure.job.api.JobParam;
import org.aksw.jena_sparql_api.conjure.traversal.api.OpTraversal;
import org.aksw.jenax.annotation.reprogen.Iri;
import org.aksw.jenax.annotation.reprogen.IriNs;
import org.aksw.jenax.annotation.reprogen.IriType;
import org.aksw.jenax.annotation.reprogen.PolymorphicOnly;
import org.aksw.jenax.annotation.reprogen.RdfType;
import org.aksw.jenax.annotation.reprogen.ResourceView;
import org.aksw.jenax.reprogen.core.JenaPluginUtils;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;

@ResourceView
@RdfType(value="rpif:Job")
public interface Job
extends Resource {
    @PolymorphicOnly
    @IriNs(value="rpif")
    public Op getOp();

    public Job setOp(Op var1);

    @IriNs(value="http://w3id.org/rpif/vocab#")
    public Set<JobParam> getParams();

    default public Iterable<String> getDeclaredVars() {
        return () -> this.getParams().stream().map(JobParam::getParamName).iterator();
    }

    default public JobParam addNewParam() {
        return (JobParam)JenaPluginUtils.addNew((RDFNode)this, JobParam.class, Job::getParams);
    }

    @Iri(value="rpif:opVar")
    public Set<String> getOpVars();

    public Job setOpVars(Collection<String> var1);

    @IriNs(value="rpif")
    public List<JobBinding> getJobBindings();

    public Job setJobBindings(List<JobBinding> var1);

    @IriNs(value="rpif")
    public String getJobName();

    public Job setJobName(String var1);

    @IriNs(value="rpif")
    public String getTag();

    public Job setTag(String var1);

    @Iri(value="dcterms:conformsTo")
    @IriType
    public Set<String> getConformances();

    default public Job addJobBinding(String varName, OpTraversal traversal) {
        this.getJobBindings().add(JobBinding.create(this.getModel(), varName, traversal));
        return this;
    }

    public static Job create(Model model) {
        Job result = (Job)model.createResource().as(Job.class);
        return result;
    }

    public static Job create(Model model, String jobName) {
        Job result = Job.create(model).setJobName(jobName);
        return result;
    }
}

