/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.http.repository.impl;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.function.Consumer;
import org.aksw.jena_sparql_api.http.repository.api.RdfHttpEntityFile;
import org.aksw.jena_sparql_api.http.repository.api.RdfHttpResourceFile;
import org.aksw.jena_sparql_api.http.repository.api.ResourceStore;
import org.apache.jena.rdf.model.Resource;

public class RdfHttpEntityFileImpl
implements RdfHttpEntityFile {
    protected RdfHttpResourceFile resource;
    protected Path relPath;

    public RdfHttpEntityFileImpl(RdfHttpResourceFile resource, Path path) {
        this.resource = resource;
        this.relPath = path;
    }

    @Override
    public RdfHttpResourceFile getResource() {
        return this.resource;
    }

    @Override
    public Path getRelativePath() {
        return this.relPath;
    }

    @Override
    public Resource getCombinedInfo() {
        Path absPath = this.getAbsolutePath();
        Resource result = this.resource.getResourceStore().getInfo(absPath);
        return result;
    }

    @Override
    public void updateInfo(Consumer<? super Resource> consumer) {
        ResourceStore store = this.getResource().getResourceStore();
        store.updateInfo(this.getAbsolutePath(), consumer);
    }

    public String toString() {
        return String.valueOf(this.relPath) + " via " + String.valueOf(this.getAbsolutePath());
    }

    @Override
    public InputStream open() throws IOException {
        Path absPath = this.getAbsolutePath();
        InputStream result = Files.newInputStream(absPath, StandardOpenOption.READ);
        return result;
    }
}

