/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.conjure.fluent;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.aksw.jena_sparql_api.conjure.dataref.rdf.api.RdfDataRef;
import org.aksw.jena_sparql_api.conjure.dataref.rdf.api.RdfDataRefUrl;
import org.aksw.jena_sparql_api.conjure.dataset.algebra.Op;
import org.aksw.jena_sparql_api.conjure.dataset.algebra.OpCoalesce;
import org.aksw.jena_sparql_api.conjure.dataset.algebra.OpData;
import org.aksw.jena_sparql_api.conjure.dataset.algebra.OpDataRefResource;
import org.aksw.jena_sparql_api.conjure.dataset.algebra.OpSequence;
import org.aksw.jena_sparql_api.conjure.dataset.algebra.OpUnion;
import org.aksw.jena_sparql_api.conjure.dataset.algebra.OpVar;
import org.aksw.jena_sparql_api.conjure.fluent.ConjureBuilder;
import org.aksw.jena_sparql_api.conjure.fluent.ConjureContext;
import org.aksw.jena_sparql_api.conjure.fluent.ConjureFluent;
import org.aksw.jena_sparql_api.conjure.fluent.ConjureFluentImpl;
import org.aksw.jenax.reprogen.core.JenaPluginUtils;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;

public class ConjureBuilderImpl
implements ConjureBuilder {
    protected ConjureContext context;

    public static ConjureBuilder start() {
        return new ConjureBuilderImpl();
    }

    public ConjureBuilderImpl() {
        this(new ConjureContext());
    }

    public ConjureBuilderImpl(ConjureContext context) {
        this.context = context;
    }

    @Override
    public ConjureContext getContext() {
        return this.context;
    }

    public ConjureFluent wrap(Op op) {
        return new ConjureFluentImpl(this.context, op);
    }

    @Override
    public ConjureFluent fromUrl(String url) {
        return this.wrap(OpDataRefResource.from(this.context.getModel(), RdfDataRefUrl.create(this.context.getModel(), url)));
    }

    @Override
    public ConjureFluent fromVar(String name) {
        return this.wrap(OpVar.create(this.context.getModel(), name));
    }

    @Override
    public ConjureFluent fromDataRefFn(Function<? super Model, ? extends RdfDataRef> dataRefFn) {
        Model model = this.context.getModel();
        RdfDataRef dataRef = dataRefFn.apply((Model)model);
        return this.wrap(OpDataRefResource.from(this.context.getModel(), dataRef));
    }

    @Override
    public ConjureFluent fromDataRef(RdfDataRef dataRef) {
        RdfDataRef copy = (RdfDataRef)JenaPluginUtils.copyInto((Resource)dataRef, RdfDataRef.class, (Model)this.context.getModel());
        return this.wrap(OpDataRefResource.from(this.context.getModel(), copy));
    }

    public static List<Op> toOps(ConjureFluent ... conjureFluents) {
        return ConjureBuilderImpl.toOps(Arrays.asList(conjureFluents));
    }

    public static List<Op> toOps(List<? extends ConjureFluent> conjureFluents) {
        List<Op> result = conjureFluents.stream().map(ConjureFluent::getOp).collect(Collectors.toList());
        return result;
    }

    @Override
    public ConjureFluent seq(ConjureFluent ... conjureFluents) {
        return this.wrap(OpSequence.create(this.context.getModel(), ConjureBuilderImpl.toOps(conjureFluents)));
    }

    @Override
    public ConjureFluent union(ConjureFluent ... conjureFluents) {
        return this.wrap(OpUnion.create(this.context.getModel(), ConjureBuilderImpl.toOps(conjureFluents)));
    }

    @Override
    public ConjureFluent coalesce(ConjureFluent ... conjureFluents) {
        return this.wrap(OpCoalesce.create(this.context.getModel(), ConjureBuilderImpl.toOps(conjureFluents)));
    }

    @Override
    public ConjureFluent call(String macroName, ConjureFluent ... conjureFluents) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public ConjureFluent fromEmptyModel() {
        return this.wrap(OpData.create(this.context.getModel()));
    }
}

