/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.conjure.entity.engine;

import io.reactivex.rxjava3.core.Single;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import org.aksw.jena_sparql_api.conjure.entity.algebra.HashUtils;
import org.aksw.jena_sparql_api.conjure.entity.algebra.HasherBase;
import org.aksw.jena_sparql_api.conjure.entity.algebra.Op;
import org.aksw.jena_sparql_api.conjure.entity.algebra.OpCode;
import org.aksw.jena_sparql_api.conjure.entity.algebra.OpConvert;
import org.aksw.jena_sparql_api.conjure.entity.algebra.OpPath;
import org.aksw.jena_sparql_api.conjure.entity.algebra.OpUtils;
import org.aksw.jena_sparql_api.conjure.entity.algebra.OpValue;
import org.aksw.jena_sparql_api.conjure.entity.algebra.OpVisitor;
import org.aksw.jena_sparql_api.conjure.entity.utils.PathCoder;
import org.aksw.jena_sparql_api.conjure.entity.utils.PathCoderRegistry;
import org.aksw.jena_sparql_api.http.domain.api.RdfEntityInfo;
import org.aksw.jena_sparql_api.http.repository.api.HttpResourceRepositoryFromFileSystem;
import org.aksw.jena_sparql_api.http.repository.api.RdfHttpEntityFile;
import org.aksw.jena_sparql_api.http.repository.api.RdfHttpResourceFile;
import org.aksw.jena_sparql_api.http.repository.api.ResourceStore;
import org.apache.http.entity.ContentType;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFLanguages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpExecutor
implements OpVisitor<Path> {
    private static final Logger logger = LoggerFactory.getLogger(OpExecutor.class);
    protected HttpResourceRepositoryFromFileSystem repository;
    protected ResourceStore hashStore;
    protected OpVisitor<String> hasher;

    public static String hashForOpPath(OpPath op, HttpResourceRepositoryFromFileSystem repository) {
        String str = op.getName();
        Path path = Paths.get(str, new String[0]);
        RdfHttpEntityFile entity = repository.getEntityForPath(path);
        if (entity == null) {
            throw new RuntimeException("Null entity; Should not happen; path=" + String.valueOf(path));
        }
        String pathHash = ResourceStore.readHash(entity, "sha256");
        String result = HashUtils.computeHash("path", pathHash);
        return result;
    }

    public OpExecutor(HttpResourceRepositoryFromFileSystem repository, ResourceStore hashStore) {
        this.repository = repository;
        this.hashStore = hashStore;
        this.hasher = HasherBase.create(op -> OpExecutor.hashForOpPath(op, repository));
    }

    public static Path execute(Op op, HttpResourceRepositoryFromFileSystem repository, ResourceStore hashStore) {
        OpExecutor executor = new OpExecutor(repository, hashStore);
        Path result = op.accept(executor);
        return result;
    }

    public Op optimizeInPlace(Op op) {
        Op result = OpUtils.optimize(op, this.hasher, this.hashStore);
        return result;
    }

    @Override
    public Path visit(OpCode op) {
        String coderName = op.getCoderName();
        PathCoder coder = PathCoderRegistry.get().getCoder(coderName);
        Objects.requireNonNull(coder, "No coder for " + coderName);
        Op subOp = op.getSubOp();
        Path srcPath = subOp.accept(this);
        Path tgtPath = this.getTargetPath(op);
        try {
            Files.createDirectories(tgtPath.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        boolean isDecode = Boolean.TRUE.equals(op.isDecode());
        logger.info("Writing " + String.valueOf(tgtPath) + " via " + coderName + " " + (isDecode ? "decoding" : "encoding") + " of " + String.valueOf(srcPath));
        Single task = isDecode ? coder.decode(srcPath, tgtPath) : coder.encode(srcPath, tgtPath);
        task.blockingGet();
        return tgtPath;
    }

    public Path getTargetPath(Op op) {
        String hash = op.accept(this.hasher);
        RdfHttpResourceFile res = this.hashStore.getResource(hash);
        RdfHttpEntityFile entity = res.allocate((Resource)((RdfEntityInfo)ModelFactory.createDefaultModel().createResource().as(RdfEntityInfo.class)).setContentType(ContentType.APPLICATION_OCTET_STREAM.toString()));
        Path result = entity.getAbsolutePath();
        return result;
    }

    @Override
    public Path visit(OpConvert op) {
        Op subOp = op.getSubOp();
        Path srcPath = subOp.accept(this);
        Path tgtPath = this.getTargetPath(op);
        String srcContentType = op.getSourceContentType();
        String tgtContentType = op.getTargetContentType();
        logger.info("Writing " + String.valueOf(tgtPath) + " (" + tgtContentType + ") from " + String.valueOf(srcPath) + "(" + srcContentType + ")");
        OpExecutor.convert(srcPath, tgtPath, srcContentType, tgtContentType);
        return tgtPath;
    }

    @Override
    public Path visit(OpPath op) {
        String str = op.getName();
        Path path = Paths.get(str, new String[0]);
        return path;
    }

    @Override
    public Path visit(OpValue op) {
        String str = Objects.toString(op.getValue());
        Path result = Paths.get(str, new String[0]);
        return result;
    }

    public static Single<Integer> convert(Path srcPath, Path tgtPath, String srcContentType, String tgtContentType) {
        try {
            Files.createDirectories(tgtPath.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Model m = ModelFactory.createDefaultModel();
        Lang srcLang = RDFLanguages.nameToLang((String)srcContentType);
        Lang tgtLang = RDFLanguages.nameToLang((String)tgtContentType);
        try (InputStream in = Files.newInputStream(srcPath, StandardOpenOption.READ);){
            RDFDataMgr.read((Model)m, (InputStream)in, (Lang)srcLang);
        }
        catch (IOException e1) {
            throw new RuntimeException(e1);
        }
        try (OutputStream out = Files.newOutputStream(tgtPath, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);){
            RDFDataMgr.write((OutputStream)out, (Model)m, (Lang)tgtLang);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return Single.just((Object)0);
    }
}

