/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.conjure.datapod.impl;

import org.aksw.commons.util.ref.Ref;
import org.aksw.jena_sparql_api.conjure.datapod.api.RdfDataPod;
import org.aksw.jena_sparql_api.conjure.datapod.impl.RdfDataPodHdt;
import org.aksw.jena_sparql_api.io.hdt.HDTHeaderGraph;
import org.aksw.jenax.arq.util.triple.GraphUtils;
import org.apache.jena.graph.Graph;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdfconnection.RDFConnection;
import org.apache.jena.rdfconnection.RDFConnectionFactory;
import org.rdfhdt.hdt.hdt.HDT;
import org.rdfhdt.hdtjena.HDTGraph;

public class RdfDataPodHdtImpl
implements RdfDataPodHdt {
    protected Ref<HDT> hdtRef;
    protected boolean isHeaderPod;

    public RdfDataPodHdtImpl(Ref<HDT> hdtRef, boolean isHeaderPod) {
        this.hdtRef = hdtRef;
        this.isHeaderPod = isHeaderPod;
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public void close() throws Exception {
        this.hdtRef.close();
    }

    @Override
    public RDFConnection getConnection() {
        HDTHeaderGraph graph;
        HDT hdt = (HDT)this.hdtRef.get();
        if (this.isHeaderPod) {
            graph = new HDTHeaderGraph(hdt);
        } else {
            graph = new HDTGraph(hdt);
            boolean enableNQuadsFix = true;
            if (enableNQuadsFix) {
                graph = GraphUtils.wrapGraphWithNQuadsFix((Graph)graph);
                graph = GraphUtils.wrapWithValidation((Graph)graph);
            }
        }
        Model model = ModelFactory.createModelForGraph((Graph)graph);
        RDFConnection result = RDFConnectionFactory.connect((Dataset)DatasetFactory.wrap((Model)model));
        return result;
    }

    @Override
    public RdfDataPod headerPod() {
        Ref freshRef = this.hdtRef.acquire((Object)this);
        if (this.isHeaderPod) {
            throw new RuntimeException("Cannot get header of a header");
        }
        return new RdfDataPodHdtImpl((Ref<HDT>)freshRef, true);
    }
}

