/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.conjure.datapod.impl;

import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.aksw.dcat.jena.domain.api.DcatDistribution;
import org.aksw.dcat.jena.domain.api.DcatUtils;
import org.aksw.jena_sparql_api.conjure.datapod.api.RdfDataPod;
import org.aksw.jena_sparql_api.conjure.datapod.impl.DataPodFactoryImpl;
import org.aksw.jena_sparql_api.conjure.datapod.impl.DataPods;
import org.aksw.jena_sparql_api.conjure.dataref.core.api.DataRefDcat;
import org.aksw.jena_sparql_api.conjure.dataref.core.api.DataRefGit;
import org.aksw.jena_sparql_api.conjure.dataref.core.api.DataRefGraph;
import org.aksw.jena_sparql_api.conjure.dataref.core.api.DataRefUrl;
import org.aksw.jena_sparql_api.conjure.dataset.algebra.OpVisitor;
import org.aksw.jena_sparql_api.conjure.dataset.engine.OpExecutorDefault;
import org.aksw.jena_sparql_api.conjure.dataset.engine.TaskContext;
import org.aksw.jena_sparql_api.http.repository.api.HttpResourceRepositoryFromFileSystem;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataPodFactoryAdvancedImpl
extends DataPodFactoryImpl {
    private static Logger logger = LoggerFactory.getLogger(DataPodFactoryAdvancedImpl.class);
    protected HttpResourceRepositoryFromFileSystem repo;
    protected Dataset dataset;

    public DataPodFactoryAdvancedImpl(Dataset dataset, OpVisitor<? extends RdfDataPod> opExecutor, HttpResourceRepositoryFromFileSystem repo) {
        super(opExecutor);
        this.dataset = dataset;
        this.repo = repo;
    }

    @Override
    public RdfDataPod visit(DataRefUrl dataRef) {
        RdfDataPod result;
        Model m;
        String url = dataRef.getDataRefUrl();
        TaskContext context = ((OpExecutorDefault)this.opExecutor).getTaskContext();
        Model model = m = context == null ? null : context.getCtxModels().get(url);
        if (m != null) {
            logger.info("Accessed input model for url " + url);
            result = DataPods.fromModel(m);
        } else {
            result = DataPods.create(url, this.repo);
        }
        return result;
    }

    @Override
    public RdfDataPod visit(DataRefGraph dataRef) {
        Objects.requireNonNull(this.dataset, "Cannot resolve DataRefGraph because no dataset has been set");
        String graphIri = dataRef.getGraphIri();
        Model model = this.dataset.getNamedModel(graphIri);
        return DataPods.fromModel(model);
    }

    @Override
    public RdfDataPod visit(DataRefDcat dataRef) {
        TaskContext context = ((OpExecutorDefault)this.opExecutor).getTaskContext();
        Node dcatRecord = dataRef.getDcatRecordNode();
        Iterator it = context.getCtxModels().entrySet().stream().iterator();
        DcatDistribution dist = null;
        while (dist == null && it.hasNext()) {
            Map.Entry e = (Map.Entry)it.next();
            Model candidateModel = (Model)e.getValue();
            Resource r = candidateModel.wrapAsResource(dcatRecord);
            dist = DcatUtils.resolveDistribution((Resource)r);
        }
        if (dist == null) {
            throw new RuntimeException("Could not resole distribution; maybe the model with information was not registered with the task context?");
        }
        String url = dist.getDownloadUrl();
        if (url == null) {
            throw new RuntimeException("Could not obtain a datasource from " + String.valueOf(dcatRecord));
        }
        RdfDataPod result = DataPods.create(url, this.repo);
        return result;
    }

    @Override
    public RdfDataPod visit(DataRefGit dataRef) {
        return super.visit(dataRef);
    }
}

