/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.http.repository.impl;

import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import org.aksw.jena_sparql_api.http.domain.api.RdfEntityInfo;
import org.aksw.jena_sparql_api.http.repository.api.RdfHttpEntityFile;
import org.aksw.jena_sparql_api.http.repository.api.ResourceStore;
import org.aksw.jena_sparql_api.http.repository.impl.HttpObjectSerializer;
import org.aksw.jena_sparql_api.http.repository.impl.HttpResourceRepositoryFromFileSystemImpl;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;

public class HttpObjectSerializerModel
implements HttpObjectSerializer<Model> {
    protected RDFFormat preferredOutFormat;

    public HttpObjectSerializerModel() {
        this(RDFFormat.TURTLE_PRETTY);
    }

    public HttpObjectSerializerModel(RDFFormat preferredOutFormat) {
        this.preferredOutFormat = preferredOutFormat;
    }

    @Override
    public HttpUriRequest createHttpRequest(String uri) {
        HttpUriRequest result = RequestBuilder.get((String)uri).setHeader("Accept", "application/n-triples").setHeader("Accept-Encoding", "identity,bzip2,gzip").build();
        return result;
    }

    @Override
    public RdfHttpEntityFile serialize(String uri, ResourceStore store, Model model) throws IOException {
        String fileExt = (String)Iterables.getFirst((Iterable)this.preferredOutFormat.getLang().getFileExtensions(), null);
        RDFFormat effectiveOutFormat = fileExt == null ? RDFFormat.TURTLE_PRETTY : this.preferredOutFormat;
        fileExt = (String)Iterables.getFirst((Iterable)effectiveOutFormat.getLang().getFileExtensions(), null);
        Objects.requireNonNull(fileExt, "Should not happen");
        Path tmpFile = Files.createTempFile("data-", fileExt, new FileAttribute[0]);
        try (OutputStream out = Files.newOutputStream(tmpFile, StandardOpenOption.WRITE);){
            RDFDataMgr.write((OutputStream)out, (Model)model, (RDFFormat)effectiveOutFormat);
        }
        catch (IOException e1) {
            throw new RuntimeException(e1);
        }
        RdfEntityInfo entityInfo = ((RdfEntityInfo)ModelFactory.createDefaultModel().createResource().as(RdfEntityInfo.class)).setContentType(effectiveOutFormat.getLang().getContentType().getContentTypeStr());
        RdfHttpEntityFile result = store.putWithMove(uri, entityInfo, tmpFile);
        HttpResourceRepositoryFromFileSystemImpl.computeHashForEntity(result, null);
        return result;
    }

    @Override
    public Model deserialize(RdfHttpEntityFile entity) {
        String absPath = entity.getAbsolutePath().toString();
        Model result = RDFDataMgr.loadModel((String)absPath);
        return result;
    }
}

