/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.conjure.fluent;

import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import org.aksw.jena_sparql_api.conjure.dataset.algebra.Op;
import org.aksw.jena_sparql_api.conjure.fluent.QLib;
import org.apache.jena.query.Query;
import org.apache.jena.update.UpdateRequest;

public interface ConjureFluent {
    public Op getOp();

    public ConjureFluent hdtHeader();

    public ConjureFluent cache();

    public ConjureFluent construct(Collection<String> var1);

    default public ConjureFluent construct(String queryStr) {
        return this.construct(Collections.singleton(queryStr));
    }

    public ConjureFluent stmts(Collection<String> var1);

    default public ConjureFluent stmt(String stmtStr) {
        return this.construct(Collections.singleton(stmtStr));
    }

    public ConjureFluent update(String var1);

    public ConjureFluent views(String ... var1);

    public ConjureFluent views(Collection<Query> var1);

    public ConjureFluent unionDefaultGraph();

    public ConjureFluent set(String var1, String var2, String var3);

    default public ConjureFluent construct(Query query) {
        return this.construct(query.toString());
    }

    default public ConjureFluent update(UpdateRequest updateRequest) {
        return this.update(updateRequest.toString());
    }

    default public ConjureFluent ofProperty(String p) {
        return this.construct("CONSTRUCT WHERE { ?s <" + p + "> ?o");
    }

    default public ConjureFluent everthing() {
        return this.construct(QLib.everything());
    }

    default public ConjureFluent tripleCount() {
        return this.construct(QLib.tripleCount());
    }

    default public ConjureFluent compose(Function<? super ConjureFluent, ? extends ConjureFluent> composer) {
        ConjureFluent result = composer.apply(this);
        return result;
    }
}

