/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.conjure.dataset.algebra;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.aksw.jena_sparql_api.conjure.dataset.algebra.Op;
import org.aksw.jena_sparql_api.conjure.dataset.algebra.Op1;
import org.aksw.jena_sparql_api.conjure.dataset.algebra.OpVisitor;
import org.aksw.jenax.annotation.reprogen.Iri;
import org.aksw.jenax.annotation.reprogen.KeyIri;
import org.aksw.jenax.annotation.reprogen.RdfTypeNs;
import org.aksw.jenax.annotation.reprogen.ResourceView;
import org.aksw.jenax.annotation.reprogen.ValueIri;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;

@ResourceView
@RdfTypeNs(value="rpif")
public interface OpJavaRewrite
extends Op1 {
    @Iri(value="rpif:rewrites")
    public List<Rewrite> getRewrites();

    default public OpJavaRewrite addRewrite(String javaClass) {
        Rewrite rewrite = (Rewrite)this.getModel().createResource().as(Rewrite.class);
        rewrite.setJavaClass(javaClass);
        this.getRewrites().add(rewrite);
        return this;
    }

    @Override
    public OpJavaRewrite setSubOp(Op var1);

    @Override
    default public <T> T accept(OpVisitor<T> visitor) {
        T result = visitor.visit(this);
        return result;
    }

    @Override
    default public OpJavaRewrite clone(Model cloneModel, List<Op> subOps) {
        OpJavaRewrite result = ((OpJavaRewrite)this.inModel(cloneModel).as(OpJavaRewrite.class)).setSubOp(subOps.iterator().next());
        List clonesTmp = this.getRewrites().stream().map(rewrite -> {
            Rewrite c = (Rewrite)rewrite.inModel(cloneModel).as(Rewrite.class);
            c.setJavaClass(rewrite.getJavaClass());
            c.getProperties().putAll(rewrite.getProperties());
            return c;
        }).collect(Collectors.toList());
        result.getRewrites().addAll(clonesTmp);
        return result;
    }

    public static OpJavaRewrite create(Op subOp) {
        return OpJavaRewrite.create(subOp.getModel(), subOp);
    }

    public static OpJavaRewrite create(Model model, Op subOp) {
        OpJavaRewrite result = ((OpJavaRewrite)model.createResource().as(OpJavaRewrite.class)).setSubOp(subOp);
        return result;
    }

    @ResourceView
    public static interface Rewrite
    extends Resource {
        @Iri(value="rpif:javaClass")
        public String getJavaClass();

        public OpJavaRewrite setJavaClass(String var1);

        @Iri(value="rpif:property")
        @KeyIri(value="rpif:key")
        @ValueIri(value="rpif:value")
        public Map<String, Node> getProperties();
    }
}

