/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.conjure.entity.engine;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.aksw.dcat.ap.domain.api.Checksum;
import org.aksw.jena_sparql_api.conjure.entity.algebra.Op;
import org.aksw.jena_sparql_api.conjure.entity.algebra.OpCode;
import org.aksw.jena_sparql_api.conjure.entity.algebra.OpConvert;
import org.aksw.jena_sparql_api.conjure.entity.algebra.OpPath;
import org.aksw.jena_sparql_api.http.domain.api.RdfEntityInfo;
import org.aksw.jena_sparql_api.http.repository.api.RdfHttpEntityFile;

public class Planner {
    public static Op createPlan(RdfHttpEntityFile source, String tgtContentType, List<String> tgtEncodings) {
        int i;
        RdfEntityInfo info = (RdfEntityInfo)source.getCombinedInfo().as(RdfEntityInfo.class);
        String srcContentType = info.getContentType();
        Checksum hashInfo = info.getHash("sha256");
        String checksum = Optional.ofNullable(hashInfo).map(Checksum::getChecksum).orElseThrow(() -> new RuntimeException("Planning requires content hash but none assigned to " + String.valueOf(source.getAbsolutePath())));
        String srcRef = source.getAbsolutePath().toString();
        Map<String, String> varToHash = Collections.singletonMap(srcRef, checksum);
        Op op = OpPath.create(srcRef);
        List srcEncodings = info.getContentEncodings();
        boolean requiresContentConversion = !srcContentType.equals(tgtContentType);
        int offset = 0;
        if (!requiresContentConversion) {
            int min = Math.min(srcEncodings.size(), tgtEncodings.size());
            for (int i2 = 0; i2 < min && srcEncodings.get(i2) == tgtEncodings.get(i2); ++i2) {
                ++offset;
            }
        }
        for (i = srcEncodings.size() - 1; i >= offset; --i) {
            String srcEncoding = (String)srcEncodings.get(i);
            op = OpCode.create(op, srcEncoding, true);
        }
        if (requiresContentConversion) {
            op = OpConvert.create(op, srcContentType, tgtContentType);
        }
        for (i = offset; i < tgtEncodings.size(); ++i) {
            String tgtEncoding = tgtEncodings.get(i);
            op = OpCode.create(op, tgtEncoding, false);
        }
        return op;
    }
}

