/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.conjure.dataset.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.aksw.jena_sparql_api.conjure.dataset.algebra.Op;
import org.aksw.jena_sparql_api.conjure.dataset.algebra.OpConstruct;
import org.aksw.jena_sparql_api.conjure.dataset.algebra.OpData;
import org.aksw.jena_sparql_api.conjure.dataset.algebra.OpQueryOverViews;
import org.aksw.jena_sparql_api.conjure.dataset.algebra.OpStmtList;
import org.aksw.jena_sparql_api.conjure.dataset.algebra.OpUpdateRequest;
import org.aksw.jena_sparql_api.conjure.dataset.engine.OpVisitorAdapter;
import org.aksw.jenax.stmt.core.SparqlStmt;
import org.aksw.jenax.stmt.core.SparqlStmtParser;
import org.aksw.jenax.stmt.util.SparqlStmtUtils;
import org.apache.jena.sparql.graph.NodeTransform;

public class OpVisitorApplyNodeTransform
extends OpVisitorAdapter<Op> {
    protected NodeTransform nodeTransform;
    protected SparqlStmtParser parser;

    public OpVisitorApplyNodeTransform(NodeTransform nodeTransform, SparqlStmtParser parser) {
        this.nodeTransform = nodeTransform;
        this.parser = parser;
    }

    public <T extends Collection<String>> T applyNodeTransform(Collection<String> strs, T output) {
        for (String str : strs) {
            String after = this.applyNodeTransform(str);
            output.add((String)after);
        }
        return output;
    }

    public String applyNodeTransform(String str) {
        SparqlStmt before = (SparqlStmt)this.parser.apply((Object)str);
        SparqlStmt after = SparqlStmtUtils.applyNodeTransform((SparqlStmt)before, (NodeTransform)this.nodeTransform);
        return after.toString();
    }

    @Override
    public Op visit(OpConstruct op) {
        ArrayList<String> strs = this.applyNodeTransform(op.getQueryStrings(), new ArrayList());
        op.setQueryStrings(strs);
        return op;
    }

    @Override
    public Op visit(OpData op) {
        return null;
    }

    @Override
    public Op visit(OpUpdateRequest op) {
        ArrayList<String> strs = this.applyNodeTransform(op.getUpdateRequests(), new ArrayList());
        op.setUpdateRequests(strs);
        return op;
    }

    @Override
    public Op visit(OpStmtList op) {
        List strs = this.applyNodeTransform(op.getStmts(), new ArrayList());
        op.setStmts(strs);
        return op;
    }

    @Override
    public Op visit(OpQueryOverViews op) {
        List strs = this.applyNodeTransform(op.getViewDefs(), new ArrayList());
        op.setViewDefs(strs);
        return op;
    }
}

