/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.http.repository.impl;

import java.util.Collection;
import java.util.Objects;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;

class ResourceUtils {
    ResourceUtils() {
    }

    public static Resource copyDirectProperties(Resource tgt, Resource src) {
        StmtIterator it = src.listProperties();
        while (it.hasNext()) {
            Statement stmt = (Statement)it.next();
            Property p = stmt.getPredicate();
            RDFNode o = stmt.getObject();
            tgt.addProperty(p, o);
        }
        return tgt;
    }

    public static Resource merge(Collection<Resource> resources) {
        Model m = ModelFactory.createDefaultModel();
        Resource result = m.createResource();
        for (Resource r : resources) {
            Objects.requireNonNull(r);
            Model n = r.getModel();
            StmtIterator it = n.listStatements();
            while (it.hasNext()) {
                Statement stmt = (Statement)it.next();
                Resource s = stmt.getSubject();
                Property p = stmt.getPredicate();
                RDFNode o = stmt.getObject();
                if (s.equals(r)) {
                    s = result;
                }
                if (o.equals(r)) {
                    o = result;
                }
                m.add(s.asResource(), p, o);
            }
        }
        return result;
    }
}

