/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.conjure.dataset.algebra;

import com.google.common.collect.Streams;
import com.google.common.graph.Traverser;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.aksw.jena_sparql_api.conjure.dataset.algebra.Op;
import org.aksw.jena_sparql_api.conjure.dataset.algebra.OpPersist;
import org.aksw.jena_sparql_api.conjure.dataset.algebra.OpVar;
import org.aksw.jena_sparql_api.conjure.dataset.engine.OpVisitorApplyNodeTransform;
import org.aksw.jenax.reprogen.core.JenaPluginUtils;
import org.aksw.jenax.stmt.core.SparqlStmtParser;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.util.ResourceUtils;

public class OpUtils {
    public static Op applyNodeTransform(Op op, NodeTransform nodeTransform, SparqlStmtParser parser) {
        OpVisitorApplyNodeTransform visitor = new OpVisitorApplyNodeTransform(nodeTransform, parser);
        Streams.stream((Iterable)Traverser.forTree(Op::getChildren).depthFirstPostOrder((Object)op)).peek(x -> x.accept(visitor)).count();
        return op;
    }

    public static Op stripCache(Op in) {
        Model cloneModel = ModelFactory.createDefaultModel();
        Op result = OpUtils.stripCacheCore(in, cloneModel);
        return result;
    }

    public static Op stripCacheCore(Op op, Model cloneModel) {
        Op result;
        if (op instanceof OpPersist) {
            OpPersist trueOp = (OpPersist)op;
            Op subOp = trueOp.getSubOp();
            result = OpUtils.stripCacheCore(subOp, cloneModel);
        } else {
            List<Op> subOps = op.getChildren();
            ArrayList<Op> newSubOps = new ArrayList<Op>(subOps.size());
            for (Op subOp : subOps) {
                Op newSubOp = OpUtils.stripCacheCore(subOp, cloneModel);
                newSubOps.add(newSubOp);
            }
            result = op.clone(cloneModel, newSubOps);
        }
        return result;
    }

    public static Op copyWithSubstitution(Op op, Map<String, ? extends Op> varNameToSubst) {
        Op result = OpUtils.copyWithSubstitution(op, varNameToSubst::get);
        return result;
    }

    public static Op copyWithSubstitution(Op op, Function<String, ? extends Op> varNameToSubst) {
        Resource resourceCopy = op.inModel(ModelFactory.createDefaultModel().add(op.getModel()));
        Op workflowCopy = (Op)JenaPluginUtils.polymorphicCast((RDFNode)resourceCopy, Op.class);
        Op result = OpUtils.substituteVars(workflowCopy, varNameToSubst);
        return result;
    }

    public static Set<String> mentionedVarNames(Op op) {
        Set<OpVar> opVars = OpUtils.mentionedVars(op);
        Set<String> result = opVars.stream().map(OpVar::getName).collect(Collectors.toSet());
        return result;
    }

    public static Set<OpVar> mentionedVars(Op op) {
        Set<OpVar> result = Streams.stream((Iterable)Traverser.forTree(Op::getChildren).depthFirstPostOrder((Object)op)).filter(x -> x instanceof OpVar).map(x -> (OpVar)x.as(OpVar.class)).collect(Collectors.toSet());
        return result;
    }

    public static Op substituteVars(Op op, Function<String, ? extends Op> varNameToSubst) {
        Set<OpVar> vars = OpUtils.mentionedVars(op);
        Op result = op;
        for (OpVar var : vars) {
            Op x;
            String name = var.getName();
            Op replacement = varNameToSubst.apply(name);
            if (replacement == null || !Objects.equals(op, x = OpUtils.substitute(var, replacement))) continue;
            result = x;
        }
        return result;
    }

    public static <T extends RDFNode> T substitute(T tgtNode, T replacement) {
        Resource replRes = replacement.asResource();
        List stmts = replRes.listProperties().toList();
        Resource tgtRes = tgtNode.asResource();
        tgtRes.removeProperties();
        Model closure = ResourceUtils.reachableClosure((Resource)replRes);
        tgtRes.getModel().add(closure);
        replRes.inModel(tgtRes.getModel()).removeProperties();
        for (Statement stmt : stmts) {
            tgtRes.addProperty(stmt.getPredicate(), stmt.getObject());
        }
        return tgtNode;
    }
}

