/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.conjure.algebra.common;

import com.google.common.collect.Maps;
import com.google.common.collect.Streams;
import com.google.common.graph.SuccessorsFunction;
import com.google.common.graph.Traverser;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import org.aksw.jena_sparql_api.rdf.collections.ResourceUtils;
import org.aksw.jenax.arq.util.var.Vars;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.out.NodeFmtLib;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.util.iterator.ExtendedIterator;

public class ResourceTreeUtils {
    public static <T> Iterable<? extends T> peekingSubOps(T op, SuccessorsFunction<T> successorsFunction) {
        Iterable result = successorsFunction.successors(op);
        System.out.println("SubOps for " + String.valueOf(op.getClass()) + " " + String.valueOf(op) + " are " + String.valueOf(result));
        return result;
    }

    public static <T> int getNumOps(T op, SuccessorsFunction<T> successorsFunction) {
        int result = (int)Streams.stream((Iterable)Traverser.forTree(successorsFunction).depthFirstPreOrder(op)).count();
        return result;
    }

    public static void clearSubTree(Resource root) {
        ResourceTreeUtils.clearSubTree(root, r -> ResourceUtils.listPropertyValues((Resource)r, null, Resource.class).toSet());
    }

    public static <T extends Resource> void clearSubTree(T rootOp, SuccessorsFunction<T> successorsFunction) {
        List ops = Streams.stream((Iterable)Traverser.forTree(successorsFunction).depthFirstPostOrder(rootOp)).collect(Collectors.toList());
        for (Resource op : ops) {
            op.removeProperties();
        }
    }

    public static HashCode generateModelHash(Model model, HashFunction hashFunction) {
        Graph graph = model.getGraph();
        HashCode result = ResourceTreeUtils.generateModelHash(graph, hashFunction);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashCode generateModelHash(Graph graph, HashFunction hashFunction) {
        HashCode result = hashFunction.hashString((CharSequence)"# begin of ntriples", StandardCharsets.UTF_8);
        try (ExtendedIterator it = graph.find();){
            while (it.hasNext()) {
                Triple t = (Triple)it.next();
                StringBuilder sb = new StringBuilder();
                sb.append((Object)(t.getSubject().isBlank() ? "_:" : t.getSubject()));
                sb.append(" ");
                sb.append(t.getPredicate());
                sb.append(" ");
                sb.append((Object)(t.getObject().isBlank() ? "_:" : t.getObject()));
                HashCode tmp = hashFunction.hashString((CharSequence)sb.toString(), StandardCharsets.UTF_8);
                result = Hashing.combineUnordered(Arrays.asList(result, tmp));
            }
        }
        return result;
    }

    public static HashCode createGenericHash(RDFNode rdfNode, boolean useInnerIris) {
        HashSet<RDFNode> seen = new HashSet<RDFNode>();
        HashMap<RDFNode, HashCode> priorHash = new HashMap<RDFNode, HashCode>();
        HashCode result = ResourceTreeUtils.createGenericHash(rdfNode, useInnerIris, (n, d) -> true, 0, seen, Hashing.sha256(), priorHash);
        return result;
    }

    public static HashCode createGenericHash(RDFNode rdfNode) {
        return ResourceTreeUtils.createGenericHash(rdfNode, false);
    }

    public static Map<RDFNode, HashCode> createGenericHashMap(RDFNode rdfNode, boolean useInnerIris, BiPredicate<? super RDFNode, ? super Integer> filterKeep) {
        HashSet<RDFNode> seen = new HashSet<RDFNode>();
        HashMap<RDFNode, HashCode> result = new HashMap<RDFNode, HashCode>();
        ResourceTreeUtils.createGenericHash(rdfNode, useInnerIris, filterKeep, 0, seen, Hashing.sha256(), result);
        return result;
    }

    public static Map<RDFNode, HashCode> createGenericHashMap(RDFNode rdfNode, boolean useInnerIris) {
        Map<RDFNode, HashCode> result = ResourceTreeUtils.createGenericHashMap(rdfNode, useInnerIris, (n, d) -> true);
        return result;
    }

    public static HashCode createGenericHash(RDFNode rdfNode, boolean useInnerIris, BiPredicate<? super RDFNode, ? super Integer> filterKeep, int depth, Set<RDFNode> seen, HashFunction hashFn, Map<RDFNode, HashCode> priorHash) {
        Objects.requireNonNull(rdfNode);
        boolean consider = filterKeep.test((RDFNode)rdfNode, (Integer)depth);
        HashCode result = priorHash.get(rdfNode);
        if (consider && result == null) {
            boolean useIriOfThisNode;
            if (seen.contains(rdfNode)) {
                throw new RuntimeException("Cannot hash graph with cycles - visited this node twice: " + String.valueOf(rdfNode));
            }
            seen.add(rdfNode);
            boolean bl = useIriOfThisNode = useInnerIris && rdfNode.isURIResource();
            if (rdfNode.isResource()) {
                Resource r = rdfNode.asResource();
                List list = r.listProperties().toList();
                ArrayList<Map.Entry> hashArgs = null;
                if (useIriOfThisNode) {
                    Object n = r.isAnon() ? Vars.x : r.asNode();
                    result = hashFn.hashString((CharSequence)NodeFmtLib.strNT((Node)n), StandardCharsets.UTF_8);
                    priorHash.put(rdfNode, result);
                }
                hashArgs = new ArrayList<Map.Entry>(list.size());
                for (Statement stmt : list) {
                    RDFNode child = stmt.getObject();
                    HashCode ch = ResourceTreeUtils.createGenericHash(child, useInnerIris, filterKeep, depth + 1, seen, hashFn, priorHash);
                    if (ch == null) continue;
                    hashArgs.add(Maps.immutableEntry((Object)stmt.getPredicate().getURI(), (Object)ch));
                }
                boolean isEffectiveLeaf = hashArgs.isEmpty();
                if (isEffectiveLeaf) {
                    if (r.isAnon()) {
                        RDFDataMgr.write((OutputStream)System.err, (Model)r.getModel(), (RDFFormat)RDFFormat.NTRIPLES);
                        throw new RuntimeException("Leaf nodes must not be blank nodes: " + NodeFmtLib.strNT((Node)r.asNode()));
                    }
                    Var n = r.isAnon() ? Vars.x : r.asNode();
                    result = hashFn.hashString((CharSequence)NodeFmtLib.strNT((Node)n), StandardCharsets.UTF_8);
                } else {
                    List hashCodes = hashArgs.stream().map(e -> hashFn.newHasher().putString((CharSequence)e.getKey(), StandardCharsets.UTF_8).putBytes(((HashCode)e.getValue()).asBytes()).hash()).collect(Collectors.toList());
                    result = Hashing.combineUnordered(hashCodes);
                }
            } else {
                result = hashFn.hashString((CharSequence)NodeFmtLib.strNT((Node)rdfNode.asNode()), StandardCharsets.UTF_8);
            }
            priorHash.put(rdfNode, result);
        }
        return result;
    }
}

