/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.conjure.utils;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static final Logger logger = LoggerFactory.getLogger(FileUtils.class);

    public static long size(Path path) {
        final AtomicLong size = new AtomicLong(0L);
        try {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    size.addAndGet(attrs.size());
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) {
                    System.out.println("skipped: " + String.valueOf(file) + " (" + String.valueOf(exc) + ")");
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                    if (exc != null) {
                        System.out.println("had trouble traversing: " + String.valueOf(dir) + " (" + String.valueOf(exc) + ")");
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new AssertionError((Object)"walkFileTree will not throw IOException if the FileVisitor does not");
        }
        return size.get();
    }

    public static Path allocateTmpFile(Path tgt) {
        Path result;
        int i = 0;
        while (true) {
            Object idx = i == 0 ? "" : "-" + i;
            result = tgt.getParent().resolve(tgt.getFileName().toString() + (String)idx + ".tmp");
            try {
                if (Files.exists(result, new LinkOption[0])) {
                    FileTime ft = Files.getLastModifiedTime(result, new LinkOption[0]);
                    Instant now = Instant.now();
                    Instant then = ft.toInstant();
                    long numHours = ChronoUnit.HOURS.between(then, now);
                    if (numHours > 24L) {
                        logger.info("Removing apparently stale tmp file " + String.valueOf(result));
                        Files.delete(result);
                    }
                }
            }
            catch (Exception e) {
                logger.warn("Attempt to check stale state and potentially removal of file failed " + String.valueOf(result), (Throwable)e);
            }
            if (!Files.exists(result, new LinkOption[0])) {
                try {
                    Files.createFile(result, new FileAttribute[0]);
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            ++i;
        }
        return result;
    }
}

